ORCA/M Asm65816 2.1.0

0001 2D80              **********************************************************************
0002 2D80              *
0003 2D80              * NewCalls.asm
0004 2D80              *
0005 2D80              * Copyright (C) 1986-1993 Apple Computer, Inc.
0006 2D80              * All rights reserved
0007 2D80              *
0008 2D80              * Original Code
0009 2D80              * by Dan Oliver
0010 2D80              *
0011 2D80              **********************************************************************
0012 2D80              *
0013 2D80              * Contains:
0014 2D80              *
0015 2D80              *                   AlertWindow
0016 2D80              *                   CompileText
0017 2D80              *                   ErrorWindow
0018 2D80              *
0019 2D80              *                   MWGetCtlPart
0020 2D80              *                   MWSetMenuProc
0021 2D80              *                   MWStdDrawProc
0022 2D80              *                   MWSetUpEditMenu
0023 2D80              *                   FindCursorCtl
0024 2D80              *
0025 2D80              **********************************************************************
0026 2D80
0027 2D80              **********************************************************************
0028 2D80              *
0029 2D80              * Change History
0030 2D80              *
0031 2D80              * 22 June 88        Harry Yee
0032 2D80              *
0033 2D80              * Converted to MAX development system. 
0034 2D80              *
0035 2D80              * 19 Oct 88         Dan O.
0036 2D80              *
0037 2D80              * Added internal call compileString.  Made AlertWindow use 
0038 2D80              * compileString call.  TaskMasterContent wasn't being called if 
0039 2D80              * TM_CONTENT was zero.  TaskMasterContent changed to track only
0040 2D80              * top window.
0041 2D80              *
0042 2D80              * 11/04/88          Dan O.
0043 2D80              *
0044 2D80              * Implemented alert string as handle or resource in addition to 
0045 2D80              * already supported pointer.
0046 2D80              *
0047 2D80              * XX Jan 89         Konstantin
0048 2D80              *
0049 2D80              * Error window added to Source.
0050 2D80              *
0051 2D80              **********************************************************************
0052 2D80                       Blanks off 
0053 2D80                       String asis 
0054 2D80
0055 2D80                       print push 
0056 2D80                       print off 
0057 2D80                       INCLUDE 'ALL.MACROS' 
0058 2D80                       INCLUDE 'e16.control' 
0059 2D80                       include 'WindMgrEquates.asm' 
0060 2D80
0061 2D80                       print pop 
0062 2D80
0063 2D80              ;===========================================
0064 2D80              ;          Create an Alert Window.
0065 2D80              ;===========================================
0066 2D80              ;
0067 2D80              ;   IN:    PUSH:WORD - space for result, button number selected.
0068 2D80              ;          PUSH:WORD - bit 0 = 0 if substitution strings are C type (null or return).
0069 2D80              ;                      bit 0 = 1 if substitution strings are Pascal type (length byte).
0070 2D80              ;                      bit 1&2 = 00 if alert string passed is a pointer.
0071 2D80              ;                      bit 1&2 = 01 if alert string passed is a handle.
0072 2D80              ;                      bit 1&2 = 11 if alert string passed is a resource ID.
0073 2D80              ;                      bit 3 = don't adjust text rectangle for icon
0074 2D80              ;                      bit 4 = do a SysBeep2 call
0075 2D80              ;                      bit 5 = space buttons unevenly
0076 2D80              ;                      bit 6 = skip initial disk-insert scan
0077 2D80              ;                      bit 7 = don't dipose of resource (make it purgeable instead)
0078 2D80              ;                      bit 8 = scan for disk insertions even without disk-swap icon
0079 2D80              ;                      bit 9 = custom icon is resource
0080 2D80              ;                      bit 10 = full color--set FontFlags to $0004
0081 2D80              ;          PUSH:LONG - pointer to substitution strings.
0082 2D80              ;          PUSH:LONG - pointer to alert string.
0083 2D80              ;
0084 2D80              ;  OUT:    WORD - button number selected.
0085 2D80              ;
0086 2D80              ;===========================================
0087 2D80                       EXPORT AlertWindow 
0088 2D80              AlertWindow PROC 
0089 2D80
0090 2D80                       import FlushKeyEvents,WindowUpdateCount 
0091 2D80
0092 2D80              alertResourceID equ   1                 ;ID of loaded alert string resource, NIL if none.
0093 2D80              alertStrgHand equ   alertResourceID+4
0094 2D80              windRect equ   alertStrgHand+4          ;RECT of window's content.
0095 2D80              xxLocInfo equ   windRect+8              ;SCB.
0096 2D80              xxImage  equ   xxLocInfo+2              ;Pointer to pixel image.
0097 2D80              xxWidth  equ   xxImage+4                ;Width of image.
0098 2D80              xxBounds equ   xxWidth+2                ;Bounds RECT of image.
0099 2D80              terminate equ   xxBounds+8
0100 2D80              separator equ   terminate+2
0101 2D80              butt1    equ   separator+2
0102 2D80              butt2    equ   butt1+4
0103 2D80              butt3    equ   butt2+4
0104 2D80              handle   equ   butt3+4
0105 2D80              ptr      equ   handle+4
0106 2D80              ptr2     equ   ptr+4
0107 2D80              taskRec  equ   ptr2+4                   ;Task record overlaps work.
0108 2D80              TheWork  equ   taskRec+exTaskRecSize
0109 2D80              alertWind equ   TheWork+8
0110 2D80              saveDpage equ   alertWind+4
0111 2D80              saveDbank equ   saveDpage+2
0112 2D80              returnAddr equ   saveDbank+1
0113 2D80              alertStrg equ   returnAddr+6
0114 2D80              substrgs equ   alertStrg+4
0115 2D80              strgType equ   substrgs+4
0116 2D80              result   equ   strgType+2
0117 2D80
0118 2D80              strgTypeBit equ   1
0119 2D80              alertStrgBit equ   6                    ;bits 1-2
0120 2D80              alertStrgPtr equ   0                    ;value for bits 1-2
0121 2D80              alertStrgHandle equ   2                 ;value for bits 1-2
0122 2D80              alertStrgResource equ   4               ;value for bits 1-2
0123 2D80
0124 2D80              rAlertString equ   $8015
0125 2D80
0126 2D80 22 64 00 E1           jsl   IncBusyFlg
0127 2D84 8B                    phb                            ;Save caller's data bank pointer
0128 2D85 0B                    phd                            ;Save caller's direct page pointer
0129 2D86
0130 2D86 3B                    tsc                            ;Swtich to direct page in stack
0131 2D87 38                    sec   
0132 2D88 E9 76 00              sbc   #saveDpage-1
0133 2D8B 1B                    tcs   
0134 2D8C 5B                    tcd   
0135 2D8D
0136 2D8D 4B                    phk                            ;Switch data bank to program bank
0137 2D8E AB                    plb   
0138 2D8F
0139 2D8F              ;
0140 2D8F              ; --- Load alert string if resource.
0141 2D8F              ;
0142 2D8F 64 01                 stz   <alertResourceID         ;Start with no resource
0143 2D91 64 03                 stz   <alertResourceID+2
0144 2D93
0145 2D93 A5 88                 lda   <strgType                ;Was a resource ID passed?
0146 2D95 29 06 00              and   #alertStrgBit
0147 2D98 F0 3E                 beq   @skip1
0148 2D9A 48                    pha   
0149 2D9B A4 80                 ldy   <alertStrg               ;Save resource ID
0150 2D9D A6 82                 ldx   <alertStrg+2
0151 2D9F 84 01                 sty   <alertResourceID
0152 2DA1 86 03                 stx   <alertResourceID+2
0153 2DA3 68                    pla   
0154 2DA4 C9 02 00              cmp   #alertStrgHandle
0155 2DA7 F0 1A                 beq   @alertHandle
0156 2DA9
0157 2DA9 48                    pha                            ;Space for result
0158 2DAA 48                    pha   
0159 2DAB F4 15 80              pea   rAlertString             ;Pass resource type of alert string
0160 2DAE DA                    phx                            ;Pass resource ID of alert string
0161 2DAF 5A                    phy   
0162 2DB0 A2 1E 0E 22           _LoadResource 
0163 2DB7 FA                    plx   
0164 2DB8 86 80                 stx   <alertStrg
0165 2DBA FA                    plx   
0166 2DBB 86 82                 stx   <alertStrg+2
0167 2DBD 90 04                 bcc   @alertHandle
0168 2DBF A8                    tay                            ;Return error code
0169 2DC0 82 84 01              brl   errorExit
0170 2DC3
0171 2DC3 A0 04 00     @alertHandle ldy   #4                   ;Lock alert string
0172 2DC6 B7 80                 lda   [<alertStrg],y
0173 2DC8 09 00 80              ora   #$8000
0174 2DCB 97 80                 sta   [<alertStrg],y
0175 2DCD 88                    dey                            ;Dereference the string
0176 2DCE 88                    dey   
0177 2DCF B7 80                 lda   [<alertStrg],y
0178 2DD1 A8                    tay   
0179 2DD2 A7 80                 lda   [<alertStrg]
0180 2DD4 85 80                 sta   <alertStrg
0181 2DD6 84 82                 sty   <alertStrg+2
0182 2DD8              @skip1    
0183 2DD8              ;
0184 2DD8              ; --- Save caller's port -------------------------------------
0185 2DD8              ;
0186 2DD8 48                    pha                            ;Space for result.
0187 2DD9 48                    pha   
0188 2DDA A2 04 1C 22           _GetPort                       ;Leave port on stack.
0189 2DE1
0190 2DE1 48                    pha                            ;Space for result.
0191 2DE2 A2 04 17 22           _GetMasterSCB 
0192 2DE9 68                    pla   
0193 2DEA 85 11                 sta   <xxLocInfo               ;Store current video mode.
0194 2DEC              ;
0195 2DEC              ; --- Turn window highlighting off ---------------------------
0196 2DEC              ;
0197 2DEC A9 01 00              lda   #1                       ;Turn window hiliting off for now.
0198 2DEF 20 7D 2F              jsr   windowGlobal
0199 2DF2              ;
0200 2DF2              ; --- Allocate a new window parameter table ------------------
0201 2DF2              ;
0202 2DF2 48                    pha                            ;Space for result.
0203 2DF3 48                    pha   
0204 2DF4 F4 00 00              pea   0                        ;Pass number of bytes to allocate.
0205 2DF7 F4 4E 00              pea   p_size
0206 2DFA F4 01 10              pea   $1001
0207 2DFD F4 10 C0              pea   $C010                    ;Pass attributes, fixed, in bank.
0208 2E00 48                    pha                            ;Pass address (not used).
0209 2E01 48                    pha   
0210 2E02 A2 02 09 22           _NewHandle 
0211 2E09 68                    pla   
0212 2E0A 85 31                 sta   <handle
0213 2E0C 68                    pla   
0214 2E0D 85 33                 sta   <handle+2
0215 2E0F
0216 2E0F 20 3E 32              jsr   derefHand                ;<ptr = (handle)
0217 2E12              ;
0218 2E12              ; ------ Initialize table ------------------------------------
0219 2E12              ;
0220 2E12 A0 4C 00              ldy   #p_size-2                ;Zero the table.
0221 2E15 A9 00 00              lda   #0
0222 2E18 97 35        lop3     sta   [<ptr],y
0223 2E1A 88                    dey   
0224 2E1B 88                    dey   
0225 2E1C 10 FA                 bpl   lop3
0226 2E1E
0227 2E1E A9 4E 00              lda   #p_size                  ;Set p_length field.
0228 2E21 87 35                 sta   [<ptr]
0229 2E23
0230 2E23 A0 02 00              ldy   #p_wFrame
0231 2E26 A9 29 20              lda   #%0010000000101001
0232 2E29 97 35                 sta   [<ptr],y
0233 2E2B
0234 2E2B A0 3A 00              ldy   #p_updateDraw
0235 2E2E A9 A5 32              lda   #UpdateGuts
0236 2E31 97 35                 sta   [<ptr],y
0237 2E33 C8                    iny   
0238 2E34 C8                    iny   
0239 2E35 A9 FD 00              lda   #UpdateGuts>>16
0240 2E38 97 35                 sta   [<ptr],y
0241 2E3A
0242 2E3A A0 46 00              ldy   #p_behind
0243 2E3D A9 FF FF              lda   #$FFFF
0244 2E40 97 35                 sta   [<ptr],y
0245 2E42 C8                    iny   
0246 2E43 C8                    iny   
0247 2E44 97 35                 sta   [<ptr],y
0248 2E46              ;
0249 2E46              ; --- Get alert window's size and position -------------------
0250 2E46              ;
0251 2E46 20 69 2F              jsr   fetchDigit               ;a = number.
0252 2E49 3A                    dec   a
0253 2E4A 10 16                 bpl   ok1                      ;Custom size and position?
0254 2E4C              ;
0255 2E4C              ;
0256 2E4C              ; ------ Custom position and size ----------------------------
0257 2E4C              ;
0258 2E4C A2 00 00              ldx   #y1
0259 2E4F A7 80        lop1     lda   [<alertStrg]
0260 2E51 95 09                 sta   <windRect,x
0261 2E53 20 76 2F              jsr   incStrg                  ;Add one to <alertStrg.
0262 2E56 20 76 2F              jsr   incStrg                  ;Add one to <alertStrg.
0263 2E59 E8                    inx   
0264 2E5A E8                    inx   
0265 2E5B E0 08 00              cpx   #x2+2
0266 2E5E D0 EF                 bne   lop1
0267 2E60 80 43                 bra   done1
0268 2E62              ;
0269 2E62              ;
0270 2E62              ; ------ Default position and size ---------------------------
0271 2E62              ;
0272 2E62 0A           ok1      asl   a                        ;Convert to index.
0273 2E63 AA                    tax   
0274 2E64
0275 2E64 A5 11                 lda   <xxLocInfo               ;320 mode?
0276 2E66 29 80 00              and   #$0080
0277 2E69 D0 05                 bne   use640high
0278 2E6B
0279 2E6B BC C0 32              ldy   heights320,x
0280 2E6E 80 03                 bra   ok2
0281 2E70
0282 2E70 BC D2 32     use640high ldy   heights640,x
0283 2E73
0284 2E73 5A           ok2      phy   
0285 2E74 A9 C8 00              lda   #200
0286 2E77 38                    sec   
0287 2E78 E3 01                 sbc   1,s
0288 2E7A 4A                    lsr   a
0289 2E7B 85 09                 sta   <windRect+y1
0290 2E7D 18                    clc   
0291 2E7E 63 01                 adc   1,s
0292 2E80 85 0D                 sta   <windRect+y2
0293 2E82 68                    pla   
0294 2E83
0295 2E83 A5 11                 lda   <xxLocInfo               ;320 mode?
0296 2E85 29 80 00              and   #$0080
0297 2E88 D0 08                 bne   use640wide
0298 2E8A
0299 2E8A BC E4 32              ldy   widths320,x
0300 2E8D A9 40 01              lda   #320
0301 2E90 80 06                 bra   store1
0302 2E92
0303 2E92 BC F6 32     use640wide ldy   widths640,x
0304 2E95 A9 80 02              lda   #640
0305 2E98 5A           store1   phy   
0306 2E99 38                    sec   
0307 2E9A E3 01                 sbc   1,s
0308 2E9C 4A                    lsr   a
0309 2E9D 85 0B                 sta   <windRect+x1
0310 2E9F 18                    clc   
0311 2EA0 63 01                 adc   1,s
0312 2EA2 85 0F                 sta   <windRect+x2
0313 2EA4 68                    pla   
0314 2EA5              done1                                   ; rect = new window portRect.
0315 2EA5
0316 2EA5 A0 44 00              ldy   #p_position+x2           ;Move <windRect into parameter table
0317 2EA8 A2 06 00              ldx   #x2
0318 2EAB B5 09        lop4     lda   <windRect,x
0319 2EAD 97 35                 sta   [<ptr],y
0320 2EAF 88                    dey   
0321 2EB0 88                    dey   
0322 2EB1 CA                    dex   
0323 2EB2 CA                    dex   
0324 2EB3 10 F6                 bpl   lop4
0325 2EB5              ;
0326 2EB5              ; --- Create the window --------------------------------------
0327 2EB5              ;
0328 2EB5 48                    pha                            ;Space for result
0329 2EB6 48                    pha   
0330 2EB7 D4 37                 pei   <ptr+2                   ;Pass address of parameter block
0331 2EB9 D4 35                 pei   <ptr
0332 2EBB A2 0E 09 22           _NewWindow 
0333 2EC2
0334 2EC2              *** Turn window hiliting back on right away
0335 2EC2 A3 01                 lda   1,s                      ;Remember alert window pointer
0336 2EC4 85 73                 sta   <alertWind
0337 2EC6 A3 03                 lda   3,s
0338 2EC8 85 75                 sta   <alertWind+2
0339 2ECA
0340 2ECA A2 04 1B 22           _SetPort                       ;Switch to window's port
0341 2ED1
0342 2ED1 D4 33                 pei   <handle+2                ;Pass handle of new window parameter
0343 2ED3 D4 31                 pei   <handle                  ;table
0344 2ED5 A2 02 10 22           _DisposeHandle 
0345 2EDC
0346 2EDC 20 88 2F              jsr   alertGuts                ;Draw guts of window.
0347 2EDF 20 4A 32              jsr   monitor                  ;Monitor alert.
0348 2EE2 85 8A                 sta   <result                  ;Return ID of button pressed.
0349 2EE4
0350 2EE4              ;
0351 2EE4              ; --- Free button controls ------------------------------------
0352 2EE4              ;
0353 2EE4 A2 08 00              ldx   #8
0354 2EE7 B5 26        lop2     lda   <butt1+1,x               ;Valid handle?
0355 2EE9 F0 12                 beq   next2
0356 2EEB
0357 2EEB DA                    phx   
0358 2EEC
0359 2EEC B5 27                 lda   <butt1+2,x               ;Free handle.
0360 2EEE 29 FF 00              and   #$00FF                   ;Clear default button flag.
0361 2EF1 48                    pha   
0362 2EF2 B5 25                 lda   <butt1,x
0363 2EF4 48                    pha   
0364 2EF5 A2 02 10 22           _DisposeHandle 
0365 2EFC
0366 2EFC FA                    plx   
0367 2EFD
0368 2EFD CA           next2    dex   
0369 2EFE CA                    dex   
0370 2EFF CA                    dex   
0371 2F00 CA                    dex   
0372 2F01 10 E4                 bpl   lop2
0373 2F03
0374 2F03              ;
0375 2F03              ; --- Dispose of alert window --------------------------------
0376 2F03              ;
0377 2F03 D4 75                 pei   <alertWind+2
0378 2F05 D4 73                 pei   <alertWind
0379 2F07 A2 0E 0B 22           _CloseWindow 
0380 2F0E
0381 2F0E              ;
0382 2F0E              ; --- Clean up stack and return ------------------------------
0383 2F0E              ;
0384 2F0E A2 04 1B 22           _SetPort                       ;Restore caller's port.
0385 2F15
0386 2F15 A9 FE FF              lda   #$FFFE
0387 2F18 20 7D 2F              jsr   windowGlobal
0388 2F1B
0389 2F1B A5 88                 lda   <strgType                ;Was a resource ID passed?
0390 2F1D 29 06 00              and   #alertStrgBit
0391 2F20 F0 22                 beq   @skip2
0392 2F22 C9 02 00              cmp   #alertStrgHandle
0393 2F25 F0 13                 beq   @alertHandle
0394 2F27
0395 2F27 F4 FF FF              pea   $FFFF
0396 2F2A F4 15 80              pea   rAlertString             ;Pass resource type of alert string.
0397 2F2D D4 03                 pei   <alertResourceID+2
0398 2F2F D4 01                 pei   <alertResourceID
0399 2F31 A2 1E 17 22           _ReleaseResource 
0400 2F38 80 0A                 bra   @skip2
0401 2F3A
0402 2F3A A0 04 00     @alertHandle ldy   #4                   ;Leave alert string handle unlocked.
0403 2F3D B7 01                 lda   [<alertResourceID],y
0404 2F3F 29 FF 7F              and   #$7FFF
0405 2F42 97 01                 sta   [<alertResourceID],y
0406 2F44              @skip2    
0407 2F44
0408 2F44 A0 00 00              ldy   #0                       ;No error.
0409 2F47
0410 2F47              errorExit  
0411 2F47 A5 7E                 lda   <returnAddr+4            ;Move return address down stack.
0412 2F49 85 88                 sta   <result-2
0413 2F4B A5 7C                 lda   <returnAddr+2
0414 2F4D 85 86                 sta   <result-4
0415 2F4F A5 7A                 lda   <returnAddr
0416 2F51 85 84                 sta   <result-6
0417 2F53
0418 2F53 3B                    tsc                            ;Free temp direct page.
0419 2F54 18                    clc   
0420 2F55 69 76 00              adc   #saveDpage-1
0421 2F58 1B                    tcs   
0422 2F59
0423 2F59 2B                    pld                            ;Restore caller's direct page pointer.
0424 2F5A AB                    plb                            ;Restore caller's data bank pointer.
0425 2F5B 68                    pla                            ;Remove input parameter from stack.
0426 2F5C 68                    pla   
0427 2F5D 68                    pla   
0428 2F5E 68                    pla   
0429 2F5F 68                    pla   
0430 2F60
0431 2F60 22 68 00 E1           jsl   DecBusyFlg
0432 2F64 98                    tya                            ;Error code.
0433 2F65 C9 01 00              cmp   #1
0434 2F68 6B                    rtl   
0435 2F69
0436 2F69              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0437 2F69              ;          Fetch and convert a ASCII decimal digit.
0438 2F69              ;100= = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0439 2F69              ;
0440 2F69              ;   IN:    alertStrg = pointer to ASCII decimal digit.
0441 2F69              ;
0442 2F69              ;  OUT:    a = digit.
0443 2F69              ;          alertStrg = advanced to next character.
0444 2F69              ;
0445 2F69 20 71 2F     fetchDigit jsr   fetchChar
0446 2F6C 38                    sec   
0447 2F6D E9 30 00              sbc   #'0'
0448 2F70 60                    rts   
0449 2F71
0450 2F71
0451 2F71              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0452 2F71              ;          Fetch character from string.
0453 2F71              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0454 2F71              ;
0455 2F71              ;   IN:    alertStrg = pointer to string.
0456 2F71              ;
0457 2F71              ;  OUT:    a = first character in string.
0458 2F71              ;          alertStrg = advanced to next character.
0459 2F71              ;
0460 2F71 A7 80        fetchChar lda   [<alertStrg]
0461 2F73 29 FF 00              and   #$00FF
0462 2F76
0463 2F76
0464 2F76              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0465 2F76              ;          Add one to <alertStrg pointer.
0466 2F76              ;110= = = = = = = = = = = = = = = = = = = = = = = = =
0467 2F76              ;
0468 2F76 E6 80        incStrg  inc   <alertStrg
0469 2F78 D0 02                 bne   exit110
0470 2F7A E6 82                 inc   <alertStrg+2
0471 2F7C 60           exit110  rts   
0472 2F7D
0473 2F7D
0474 2F7D              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0475 2F7D              ;          Set Window Manager global flag.
0476 2F7D              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0477 2F7D              ;
0478 2F7D              ;   IN:    a = flag.
0479 2F7D              ;
0480 2F7D 48           windowGlobal pha                        ;Space for result.
0481 2F7E 48                    pha                            ;Turn window hiliting back on.
0482 2F7F A2 0E 56 22           _WindowGlobal 
0483 2F86 68                    pla                            ;No need for result.
0484 2F87 60                    rts   
0485 2F88
0486 2F88
0487 2F88              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0488 2F88              ;          Create and draw contents of alert.
0489 2F88              ;200= = = = = = = = = = = = = = = = = = = = = = = = =
0490 2F88              ;
0491 2F88              ;   IN:    alertStrg = pointer to icon character in string:
0492 2F88              ;
0493 2F88              ;                1/Alert text./Button 1/Button 2/Button 3
0494 2F88              ;
0495 2F88              ;                Icon numbers:
0496 2F88              ;                   0 = custom icon, pointer follows.
0497 2F88              ;                   1 = no icon.
0498 2F88              ;                   2 = stop
0499 2F88              ;                   3 = note
0500 2F88              ;                   4 = caution
0501 2F88              ;                   5 = disk
0502 2F88              ;                   6 = disk swap
0503 2F88              ;                   7-9 = reserved
0504 2F88              ;
0505 2F88              alertGuts  
0506 2F88              ;
0507 2F88              ; --- Draw icon ----------------------------------------------
0508 2F88              ;
0509 2F88 64 1F                 stz   <xxBounds+x2             ;No icon, just in case.
0510 2F8A
0511 2F8A 20 69 2F              jsr   fetchDigit
0512 2F8D
0513 2F8D 3A                    dec   a                        ;No icon?
0514 2F8E 10 03                 bpl   ok204
0515 2F90 82 85 00              brl   skip200
0516 2F93 3A           ok204    dec   a
0517 2F94 10 23                 bpl   @ok200                   ;Custom icon?
0518 2F96
0519 2F96 A7 80                 lda   [<alertStrg]             ;Get pointer to image data.
0520 2F98 85 13                 sta   <xxImage
0521 2F9A A0 02 00              ldy   #2
0522 2F9D B7 80                 lda   [<alertStrg],y
0523 2F9F 85 15                 sta   <xxImage+2
0524 2FA1
0525 2FA1 C8                    iny   
0526 2FA2 C8                    iny                            ;y is now 4
0527 2FA3 B7 80                 lda   [<alertStrg],y           ;Get width, in bytes.
0528 2FA5 AA                    tax   
0529 2FA6 C8                    iny   
0530 2FA7 C8                    iny   
0531 2FA8 B7 80                 lda   [<alertStrg],y           ;Get height.
0532 2FAA A8                    tay   
0533 2FAB
0534 2FAB A5 80                 lda   <alertStrg               ;Skip over custom icon data.
0535 2FAD 18                    clc   
0536 2FAE 69 08 00              adc   #8
0537 2FB1 85 80                 sta   <alertStrg
0538 2FB3 90 30                 bcc   store200
0539 2FB5 E6 82                 inc   <alertStrg+2
0540 2FB7 80 2C                 bra   store200
0541 2FB9
0542 2FB9              @ok200    
0543 2FB9 0A                    asl   a
0544 2FBA AA                    tax   
0545 2FBB A9 FD 00              lda   #H3308>>16               ;segment of table
0546 2FBE 85 15                 sta   <xxImage+2
0547 2FC0 BD 08 33              lda   H3308,x
0548 2FC3 C9 D6 34              cmp   #H34D6
0549 2FC6 D0 14                 bne   H2FDC
0550 2FC8 A4 10                 ldy   <xxH10
0551 2FCA 10 10                 bpl   H2FDC
0552 2FCC A9 AE 35              lda   #H35AE
0553 2FCF 85 13                 sta   <xxImage
0554 2FD1 BC 12 33              ldy   H3312,x
0555 2FD4 BD 1C 33              lda   H331C,x
0556 2FD7 AA                    tax   
0557 2FD8 CA                    dex   
0558 2FD9 CA                    dex   
0559 2FDA 80 09                 bra   store200
0560 2FDC 85 13        H2FDC    sta   <xxImage
0561 2FDE BC 12 33              ldy   H3312,x
0562 2FE1 BD 1C 33              lda   H331C,x
0563 2FE4 AA                    tax   
0564 2FE5
0565 2FE5 84 1D        store200 sty   <xxBounds+y2
0566 2FE7 86 17                 stx   <xxWidth
0567 2FE9 8A                    txa                            ;Compute width in pixels.
0568 2FEA 0A                    asl   a                        ;2 pixels per byte.
0569 2FEB              commonStoreBounds  
0570 2FEB A6 10                 ldx   <xxLocInfo-1             ;320 or 640 mode?
0571 2FED 10 01                 bpl   store202
0572 2FEF 0A                    asl   a                        ;4 pixels per byte.
0573 2FF0 85 1F        store202 sta   <xxBounds+x2
0574 2FF2 64 19                 stz   <xxBounds+y1
0575 2FF4 64 1B                 stz   <xxBounds+x1
0576 2FF6
0577 2FF6 A9 11 00              lda   #<xxLocInfo
0578 2FF9 20 B3 32              jsr   pushDpage
0579 2FFC A9 19 00              lda   #<xxBounds
0580 2FFF 20 B3 32              jsr   pushDpage
0581 3002 A9 04 00              lda   #4
0582 3005 A6 10                 ldx   <xxH10
0583 3007 10 01                 bpl   H300A
0584 3009 0A                    asl   a
0585 300A 48           H300A    pha   
0586 300B F4 04 00              pea   4
0587 300E F4 00 00              pea   0
0588 3011 A2 04 D6 22           _PPToPort 
0589 3018
0590 3018              ;
0591 3018              ; --- Perform substitution on rest of string.
0592 3018              ;
0593 3018 A0 00 00     skip200  ldy   #0                       ;Compute size of rest of alert string.
0594 301B E2 20                 sep   #$20
0595 301D                       LONGA OFF
0596 301D A7 80                 lda   [<alertStrg]
0597 301F C8           @lop200  iny   
0598 3020 D7 80                 cmp   [<alertStrg],y
0599 3022 D0 FB                 bne   @lop200
0600 3024 C8           @lop201  iny   
0601 3025 B7 80                 lda   [<alertStrg],y
0602 3027 D0 FB                 bne   @lop201
0603 3029 C2 20                 rep   #$20
0604 302B                       LONGA ON
0605 302B C8                    iny                            ;Move the zero also.
0606 302C
0607 302C 48                    pha                            ;Space for result.
0608 302D 48                    pha   
0609 302E A5 88                 lda   <strgType                ;Pass substitution string type.
0610 3030 29 01 00              and   #strgTypeBit
0611 3033 48                    pha   
0612 3034 D4 86                 pei   <substrgs+2              ;Pass pointer to substitution strings.
0613 3036 D4 84                 pei   <substrgs
0614 3038 D4 82                 pei   <alertStrg+2             ;Pass pointer to source string.
0615 303A D4 80                 pei   <alertStrg
0616 303C 5A                    phy                            ;Pass size of alert string.
0617 303D A2 0E 60 22           _CompileText 
0618 3044
0619 3044 68                    pla                            ;Handle of compiled alert string.
0620 3045 85 05                 sta   <alertStrgHand
0621 3047 68                    pla   
0622 3048 85 07                 sta   <alertStrgHand+2
0623 304A
0624 304A A0 04 00              ldy   #4
0625 304D B7 05                 lda   [<alertStrgHand],y
0626 304F 09 00 80              ora   #$8000
0627 3052 97 05                 sta   [<alertStrgHand],y
0628 3054 88                    dey   
0629 3055 88                    dey   
0630 3056 B7 05                 lda   [<alertStrgHand],y
0631 3058 85 82                 sta   <alertStrg+2
0632 305A A7 05                 lda   [<alertStrgHand]
0633 305C 85 80                 sta   <alertStrg
0634 305E
0635 305E              ;
0636 305E              ; --- Get separation character -------------------------------
0637 305E              ;
0638 305E 20 71 2F              jsr   fetchChar
0639 3061 85 23                 sta   <separator               ;Text terminator.
0640 3063 85 21                 sta   <terminate               ;Alert string terminator.
0641 3065
0642 3065              ;
0643 3065              ; --- Compile text string ------------------------------------
0644 3065              ;
0645 3065 A9 E9 03              lda   #MaxString               ;Maximum number of characters.
0646 3068 20 E5 31              jsr   compileStrg
0647 306B A6 6B                 ldx   <TheWork                 ;Length of string.
0648 306D
0649 306D              ;
0650 306D              ; --- Print text box -----------------------------------------
0651 306D              ;
0652 306D              rect2    equ   TheWork
0653 306D
0654 306D A5 0D                 lda   <windRect+y2
0655 306F 38                    sec   
0656 3070 E5 09                 sbc   <windRect+y1
0657 3072 85 6F                 sta   <rect2+y2
0658 3074
0659 3074 A5 0F                 lda   <windRect+x2
0660 3076 38                    sec   
0661 3077 E5 0B                 sbc   <windRect+x1
0662 3079 E9 08 00              sbc   #8
0663 307C A4 10                 ldy   <xxLocInfo-1             ;320 or 640 mode?
0664 307E 10 03                 bpl   store204
0665 3080 E9 08 00              sbc   #8
0666 3083 85 71        store204 sta   <rect2+x2
0667 3085
0668 3085 A9 03 00              lda   #TextTop
0669 3088 85 6B                 sta   <rect2+y1
0670 308A
0671 308A A5 1F                 lda   <xxBounds+x2             ;Right side of icon,
0672 308C 18                    clc   
0673 308D 69 0A 00              adc   #10                      ;plus some padding.
0674 3090 A4 10                 ldy   <xxLocInfo-1             ;320 or 640 mode?
0675 3092 10 03                 bpl   store205
0676 3094 69 0A 00              adc   #10                      ;More padding in 640 mode.
0677 3097 85 6D        store205 sta   <rect2+x1
0678 3099 D4 37                 pei   <ptr+2
0679 309B A5 35                 lda   <ptr
0680 309D 1A                    inc   a                        ;Skip length byte (does not cross bank)
0681 309E 48                    pha   
0682 309F DA                    phx                            ;Pass length of string.
0683 30A0 20 AB 32              jsr   pushrect2                ;Pass pointer to text box.
0684 30A3 F4 00 00              pea   0                        ;Pass 'left justification' flag.
0685 30A6 A2 14 20 22           _LETextBox2 
0686 30AD
0687 30AD D4 33                 pei   <handle+2
0688 30AF D4 31                 pei   <handle
0689 30B1 A2 02 10 22           _DisposeHandle 
0690 30B8
0691 30B8              ;
0692 30B8              ; --- Get button titles --------------------------------------
0693 30B8              ;
0694 30B8              buttCount equ   TheWork+2
0695 30B8
0696 30B8 64 26                 stz   <butt1+1                 ;Set 'no title' flag.
0697 30BA 64 2A                 stz   <butt2+1                 ;Set 'no title' flag.
0698 30BC 64 2E                 stz   <butt3+1                 ;Set 'no title' flag.
0699 30BE
0700 30BE 64 6D                 stz   <buttCount               ;Button counter.
0701 30C0 85 21                 sta   <terminate
0702 30C2
0703 30C2 A9 51 00     lop200   lda   #MaxButtStrg             ;Maximum number of characters.
0704 30C5 20 E5 31              jsr   compileStrg
0705 30C8 08                    php                            ;Save 'end of string' flag.
0706 30C9
0707 30C9 A5 6D                 lda   <buttCount               ;Remember handle of title.
0708 30CB 0A                    asl   a
0709 30CC 0A                    asl   a
0710 30CD AA                    tax   
0711 30CE A5 31                 lda   <handle
0712 30D0 95 25                 sta   <butt1,x
0713 30D2 A5 33                 lda   <handle+2
0714 30D4 95 27                 sta   <butt1+2,x
0715 30D6
0716 30D6 E6 6D                 inc   <buttCount
0717 30D8 28                    plp                            ;End of alert string?
0718 30D9 90 E7                 bcc   lop200
0719 30DB
0720 30DB C6 6D                 dec   <buttCount               ;Zero relative.
0721 30DD
0722 30DD              ;
0723 30DD              ; --- Find widest title --------------------------------------
0724 30DD              ;
0725 30DD              counter  equ   TheWork
0726 30DD              widest   equ   TheWork+4
0727 30DD
0728 30DD A5 6D                 lda   <buttCount               ;Start with last button.
0729 30DF 85 6B                 sta   <counter
0730 30E1 64 6F                 stz   <widest                  ;Start with no width.
0731 30E3
0732 30E3 A5 6B        lop201   lda   <counter
0733 30E5 0A                    asl   a
0734 30E6 0A                    asl   a
0735 30E7 AA                    tax   
0736 30E8 B5 25                 lda   <butt1,x
0737 30EA 85 31                 sta   <handle
0738 30EC B5 26                 lda   <butt1+1,x
0739 30EE 85 32                 sta   <handle+1
0740 30F0
0741 30F0 48                    pha                            ;Space for result.
0742 30F1 A0 02 00              ldy   #2                       ;Pass pointer to string.
0743 30F4 B7 31                 lda   [<handle],y
0744 30F6 48                    pha   
0745 30F7 A7 31                 lda   [<handle]
0746 30F9 48                    pha   
0747 30FA A2 04 A9 22           _StringWidth 
0748 3101 68                    pla   
0749 3102 C5 6F                 cmp   <widest                  ;Is this button the widest so far?
0750 3104 90 02                 bcc   next201
0751 3106 85 6F                 sta   <widest                  ;Remember widest.
0752 3108
0753 3108 C6 6B        next201  dec   <counter
0754 310A 10 D7                 bpl   lop201
0755 310C
0756 310C A5 6F                 lda   <widest                  ;Pad the button size.
0757 310E 18                    clc   
0758 310F A4 10                 ldy   <xxLocInfo-1             ;320 or 640 mode?
0759 3111 10 0D                 bpl   ck320min
0760 3113
0761 3113 69 14 00              adc   #20
0762 3116 C9 3C 00              cmp   #minWidth640             ;Minimum size?
0763 3119 B0 12                 bcs   store201
0764 311B A9 3C 00              lda   #minWidth640             ;Make minimum size.
0765 311E 80 0D                 bra   store201
0766 3120              ;
0767 3120 69 0A 00     ck320min adc   #10
0768 3123 C9 1E 00              cmp   #minWidth320             ;Minimum size?
0769 3126 B0 05                 bcs   store201
0770 3128 A9 1E 00              lda   #minWidth320             ;Make minimum size.
0771 312B 80 00                 bra   store201
0772 312D
0773 312D 85 6F        store201 sta   <widest
0774 312F
0775 312F              ;
0776 312F              ; --- Compute space between buttons --------------------------
0777 312F              ;
0778 312F              Thewidth equ   TheWork
0779 312F
0780 312F 64 6B                 stz   <TheWidth                ;No space between buttons, just in case.
0781 3131
0782 3131 A5 0F                 lda   <windRect+x2             ;Compute width of window.
0783 3133 38                    sec   
0784 3134 E5 0B                 sbc   <windRect+x1
0785 3136
0786 3136 A6 6D                 ldx   <buttCount
0787 3138 E5 6F        lop202   sbc   <widest
0788 313A 90 22                 bcc   done2                    ;Buttons don't fit in window?
0789 313C CA                    dex   
0790 313D 10 F9                 bpl   lop202
0791 313F              ;                                       a = space between all buttons.
0792 313F
0793 313F A6 6D                 ldx   <buttCount               ;Compute space between buttons.
0794 3141 D0 03                 bne   next203
0795 3143
0796 3143 4A                    lsr   a                        ;One button.
0797 3144 80 16                 bra   store203
0798 3146
0799 3146 CA           next203  dex   
0800 3147 D0 11                 bne   threeButts
0801 3149
0802 3149 48                    pha                            ;Space for result.
0803 314A 48                    pha   
0804 314B 48                    pha                            ;Pass remaining space.
0805 314C F4 03 00              pea   3                        ;Divide by 3.
0806 314F A2 0B 0B 22           _UDivide 
0807 3156 68                    pla                            ;Get quotient
0808 3157 FA                    plx                            ;Get remainder (not used).
0809 3158 80 02                 bra   store203
0810 315A
0811 315A 4A           threeButts lsr   a
0812 315B 4A                    lsr   a
0813 315C
0814 315C 85 6B        store203 sta   <TheWidth                ;Width between buttons.
0815 315E              done2     
0816 315E
0817 315E              ;
0818 315E              ; --- Create buttons -----------------------------------------
0819 315E              ;
0820 315E              counter2 equ   TheWork+6
0821 315E              ;
0822 315E 64 3A                 stz   <ptr2+1                  No default button flag, just in case.
0823 3160              ;
0824 3160 A5 0D                 lda   <windRect+y2
0825 3162 38                    sec   
0826 3163 E5 09                 sbc   <windRect+y1
0827 3165 E9 05 00              sbc   #5
0828 3168 85 0D                 sta   <windRect+y2
0829 316A E9 0D 00              sbc   #13
0830 316D 85 09                 sta   <windRect+y1
0831 316F              ;
0832 316F 64 0F                 stz   <windRect+x2
0833 3171 64 71                 stz   <counter2
0834 3173              ;
0835 3173 A5 71        lop204   lda   <counter2
0836 3175 0A                    asl   a
0837 3176 0A                    asl   a
0838 3177 AA                    tax   
0839 3178 B5 25                 lda   <butt1,x
0840 317A 85 31                 sta   <handle
0841 317C B5 27                 lda   <butt1+2,x
0842 317E 85 33                 sta   <handle+2
0843 3180              ;
0844 3180 A5 0F                 lda   <windRect+x2
0845 3182 18                    clc   
0846 3183 65 6B                 adc   <TheWidth
0847 3185 85 0B                 sta   <windRect+2
0848 3187 65 6F                 adc   <TheWork+4
0849 3189 85 0F                 sta   <windRect+6
0850 318B 48                    pha   
0851 318C 48                    pha   
0852 318D D4 75                 pei   <alertWind+2
0853 318F D4 73                 pei   <alertWind
0854 3191 A9 09 00              lda   #<WindRect
0855 3194 20 B3 32              jsr   pushDpage
0856 3197
0857 3197 A0 02 00              ldy   #2
0858 319A B7 31                 lda   [<handle],y
0859 319C 48                    pha   
0860 319D A7 31                 lda   [<handle]
0861 319F 48                    pha   
0862 31A0
0863 31A0 A5 33                 lda   <handle+2
0864 31A2 2A                    rol   a
0865 31A3 2A                    rol   a
0866 31A4 29 01 00              and   #1
0867 31A7
0868 31A7 48                    pha   
0869 31A8 A9 00 00              lda   #0
0870 31AB 48                    pha   
0871 31AC 48                    pha   
0872 31AD 48                    pha   
0873 31AE 48                    pha   
0874 31AF 48                    pha   
0875 31B0 48                    pha   
0876 31B1 D4 71                 pei   <TheWork+6
0877 31B3 48                    pha   
0878 31B4 48                    pha                            ;space for NewControl2 result
0879 31B5 A2 10 09 22           _NewControl 
0880 31BC 68                    pla   
0881 31BD FA                    plx   
0882 31BE
0883 31BE A4 33                 ldy   <handle+2                ;Was that the default button?
0884 31C0 10 04                 bpl   next204
0885 31C2
0886 31C2 85 39                 sta   <ptr2                    ;Remember default button's handle.
0887 31C4 86 3B                 stx   <ptr2+2
0888 31C6
0889 31C6 E6 71        next204  inc   <counter2
0890 31C8 A5 6D                 lda   <buttCount
0891 31CA C5 71                 cmp   <counter2
0892 31CC B0 A5                 bcs   lop204
0893 31CE
0894 31CE              ;
0895 31CE              ; --- Draw buttons -------------------------------------------
0896 31CE              ;
0897 31CE D4 75                 pei   <alertWind+2             ;Draw buttons in alert.
0898 31D0 D4 73                 pei   <alertWind
0899 31D2 A2 10 10 22           _DrawControls 
0900 31D9
0901 31D9 D4 07                 pei   <alertStrgHand+2         ;Free compiled string.
0902 31DB D4 05                 pei   <alertStrgHand
0903 31DD A2 02 10 22           _DisposeHandle 
0904 31E4
0905 31E4 60                    rts   
0906 31E5
0907 31E5              ; = = = = = = = = = = = = = = = = = = = = =
0908 31E5              ;          Compile a text string.
0909 31E5              ;800= = = = = = = = = = = = = = = = = = = =
0910 31E5              ;
0911 31E5              ;   IN:    a = maximum size of string.
0912 31E5              ;          <alertStrg = pointer to string.
0913 31E5              ;          <separator = text termination character.
0914 31E5              ;          <terminate = alert string termination character.
0915 31E5              ;          <DoingButtons = bit 15 set if we're parsing button text (DAL)
0916 31E5              ;
0917 31E5              ;  OUT:    <handle = handle of text string, high bit set if '>' found.
0918 31E5              ;          <ptr = pointer to string (length byte first).
0919 31E5              ;          <work = length of string.
0920 31E5              ;          Carry set if end of alert string.
0921 31E5              ;
0922 31E5              compileStrg  
0923 31E5
0924 31E5              buffSize equ   1
0925 31E5              ;
0926 31E5 48                    pha                            ;Save buffer size.
0927 31E6
0928 31E6              ;
0929 31E6              ; --- Allocate memory for text string ------------------------
0930 31E6              ;
0931 31E6 48                    pha                            ;Space for result.
0932 31E7 48                    pha   
0933 31E8 F4 00 00              pea   0                        ;Pass number of bytes to allocate.
0934 31EB 48                    pha   
0935 31EC F4 01 10              pea   $1001                    ;pass ID to use
0936 31EF F4 10 C0              pea   $C010                    ;Pass attributes, fixed, in bank.
0937 31F2 48                    pha                            ;Pass address (not used).
0938 31F3 48                    pha   
0939 31F4 A2 02 09 22           _NewHandle 
0940 31FB 68                    pla   
0941 31FC 85 31                 sta   <handle
0942 31FE 68                    pla   
0943 31FF 85 33                 sta   <handle+2
0944 3201
0945 3201 20 3E 32              jsr   derefHand                ;ptr = (handle)
0946 3204
0947 3204 E6 35                 inc   <ptr                     ;Start past length byte.
0948 3206 64 6B                 stz   <TheWork                 ;Start length counter.
0949 3208
0950 3208 68                    pla                            ;Adjust max buffer size for easy compare.
0951 3209 3A                    dec   a
0952 320A 48                    pha   
0953 320B              ;
0954 320B              ;
0955 320B              ; --- Compile text string ------------------------------------
0956 320B              ;
0957 320B 20 71 2F     lop800   jsr   fetchChar
0958 320E
0959 320E              *** "^" is not special until we get to the button text
0960 320E C9 5E 00              cmp   #'^'                     ;Default character for buttons?
0961 3211 D0 09                 bne   next802
0962 3213
0963 3213 A5 33                 lda   <handle+2
0964 3215 09 00 80              ora   #$8000
0965 3218 85 33                 sta   <handle+2
0966 321A 80 EF                 bra   lop800
0967 321C
0968 321C C5 23        next802  cmp   <separator               ;End of this string?
0969 321E F0 10                 beq   exit800
0970 3220 C5 21                 cmp   <terminate               ;End of line?
0971 3222 F0 0D                 beq   exit801
0972 3224
0973 3224 87 35        store800 sta   [<ptr]                   ;Store character in text string.
0974 3226 E6 35                 inc   <ptr
0975 3228 E6 6B                 inc   <TheWork                 ;Length counter.
0976 322A
0977 322A A5 6B                 lda   <TheWork                 ;Is buffer full?
0978 322C C3 01                 cmp   buffSize,s
0979 322E 90 DB                 bcc   lop800
0980 3230              ; End line if buffer full.
0981 3230
0982 3230 18           exit800  clc                            ;Continue flag.
0983 3231              ;
0984 3231 20 3E 32     exit801  jsr   derefHand                ;ptr = (handle).
0985 3234              ;
0986 3234 E2 30                 sep   #$30                     ;Store length byte.
0987 3236 A5 6B                 lda   <TheWork
0988 3238 87 35                 sta   [<ptr]
0989 323A C2 30                 rep   #$30
0990 323C              ;
0991 323C 68                    pla                            ;Get rid of buffer size.
0992 323D 60                    rts   
0993 323E              ;
0994 323E              ;
0995 323E              ; = = = = = = = = = = = = = = = = = = = =
0996 323E              ;          Dereference handle.
0997 323E              ; = = = = = = = = = = = = = = = = = = = =
0998 323E              ;
0999 323E A0 02 00     derefHand ldy   #2                      ;Dereference the handle.
1000 3241 B7 31                 lda   [<handle],y
1001 3243 85 37                 sta   <ptr+2
1002 3245 A7 31                 lda   [<handle]
1003 3247 85 35                 sta   <ptr
1004 3249 60                    rts   
1005 324A              ;
1006 324A              ;
1007 324A              ; = = = = = = = = = = = = = = = = = =
1008 324A              ;          Monitor the alert.
1009 324A              ;900= = = = = = = = = = = = = = = = =
1010 324A              ;
1011 324A              ;   IN:    alertWind = window to monitor.
1012 324A              ;          ptr2 = handle of default button, ptr2+1 = zero if none.
1013 324A              ;
1014 324A A9 06 80     monitor  lda   #%1000000000000110
1015 324D 85 51                 sta   <taskRec+TaskMask
1016 324F A9 01 00              lda   #%0000000000000001       ;tmContentControls
1017 3252 85 53                 sta   <taskRec+TaskMask+2
1018 3254
1019 3254 48           poll900  pha                            ;Space for result.
1020 3255 F4 2E 0E              pea   $0E2E                    ;Mouse Up+Down, keys, switch, deskAcc, driver
1021 3258 20 B0 32              jsr   pushTask                 ;Pass pointer to Task record.
1022 325B A2 0E 1D 22           _TaskMaster 
1023 3262 68                    pla   
1024 3263 F0 EF                 beq   poll900
1025 3265
1026 3265              ;
1027 3265              ; --- Handle event ----------------------------------------------------
1028 3265              ;
1029 3265 C9 21 00              cmp   #wInControl
1030 3268 D0 12                 bne   next900
1031 326A
1032 326A A5 5B        enter899 lda   <taskRec+taskData2       ;Handle of selected button.
1033 326C A6 5D                 ldx   <taskRec+taskData2+2
1034 326E
1035 326E 48           enter900 pha                            ;Space for result.
1036 326F 48                    pha   
1037 3270 DA                    phx                            ;Pass handle of selected control.
1038 3271 48                    pha   
1039 3272 A2 10 23 22           _GetCtlRefCon                  ;Get control's refCon.
1040 3279 68                    pla                            ;Control's ID number.
1041 327A FA                    plx   
1042 327B 60                    rts   
1043 327C              ;
1044 327C              ; --- Handle key event ---------------------------------------
1045 327C              ;
1046 327C C9 03 00     next900  cmp   #wInKey                  ;Key?
1047 327F F0 05                 beq   doKey
1048 3281 C9 05 00              cmp   #wInAutoKey
1049 3284 D0 CE                 bne   poll900
1050 3286
1051 3286 A5 3F        doKey    lda   <taskRec+message
1052 3288 C9 0D 00              cmp   #$0D                     ;cr
1053 328B D0 C7                 bne   poll900
1054 328D A5 3A                 lda   <ptr2+1
1055 328F F0 C3                 beq   poll900
1056 3291 F4 02 00              pea   2
1057 3294 D4 3B                 pei   <ptr2+2
1058 3296 D4 39                 pei   <ptr2
1059 3298 A2 10 11 22           _HiliteControl 
1060 329F A5 39                 lda   <ptr2
1061 32A1 A6 3B                 ldx   <ptr2+2
1062 32A3 80 C9                 bra   enter900
1063 32A5              UpdateGuts  
1064 32A5 6B                    rtl   
1065 32A6
1066 32A6
1067 32A6              ; = = = = = = = = = = = = = = = = = = = =
1068 32A6              ;          Push a direct page
1069 32A6              ;          address on the stack.
1070 32A6              ; = = = = = = = = = = = = = = = = = = = =
1071 32A6              ;
1072 32A6              ;   IN:    a = direct page offset.
1073 32A6              ;
1074 32A6 A9 31 00     pushHandle lda   #handle
1075 32A9 80 08                 bra   pushDpage
1076 32AB
1077 32AB A9 6B 00     pushrect2 lda   #rect2
1078 32AE 80 03                 bra   pushDpage
1079 32B0
1080 32B0 A9 3D 00     pushTask lda   #taskRec
1081 32B3 FA           pushDpage plx   
1082 32B4 F4 00 00              pea   0
1083 32B7 48                    pha   
1084 32B8 7B                    tdc   
1085 32B9 18                    clc   
1086 32BA 63 01                 adc   1,s
1087 32BC 83 01                 sta   1,s
1088 32BE DA                    phx   
1089 32BF 60                    rts   
1090 32C0
1091 32C0              ;
1092 32C0              ; --- Task Master return codes -------------------------------
1093 32C0              ;
1094 32C0              wInKey   equ   3
1095 32C0              wInAutoKey equ   5
1096 32C0
1097 32C0              ;
1098 32C0              ; --- Alert window default sizes -----------------------------
1099 32C0              ;
1100 32C0              MaxString equ   1001                    Maximum length of alert text.
1101 32C0              MaxButtStrg equ   81                    Maximum length of button string.
1102 32C0              minWidth320 equ   30                    Minimum button width in 320 mode.
1103 32C0              minWidth640 equ   60                    Minimum button width in 640 mode.
1104 32C0
1105 32C0              TextTop  equ   3                        Y position of first line of text.
1106 32C0
1107 32C0 2E 00        heights320 DC W:46                      1
1108 32C2 3E 00                 DC W:62                        2
1109 32C4 3E 00                 DC W:62                        3
1110 32C6 5A 00                 DC W:90                        4
1111 32C8 36 00                 DC W:54                        5
1112 32CA 3E 00                 DC W:62                        6
1113 32CC 50 00                 DC W:80                        7
1114 32CE 6C 00                 DC W:108                       8
1115 32D0 86 00                 DC W:134                       9
1116 32D2
1117 32D2 2E 00        heights640 DC W:46                      1
1118 32D4 36 00                 DC W:54                        2
1119 32D6 3E 00                 DC W:62                        3
1120 32D8 48 00                 DC W:72                        4
1121 32DA 2E 00                 DC W:46                        5
1122 32DC 36 00                 DC W:54                        6
1123 32DE 3E 00                 DC W:62                        7
1124 32E0 48 00                 DC W:72                        8
1125 32E2 50 00                 DC W:80                        9
1126 32E4
1127 32E4 98 00        widths320 DC W:152                      1
1128 32E6 B0 00                 DC W:176                       2
1129 32E8 FC 00                 DC W:252                       3
1130 32EA FC 00                 DC W:252                       4
1131 32EC FC 00                 DC W:252                       5
1132 32EE 2C 01                 DC W:300                       6
1133 32F0 2C 01                 DC W:300                       7
1134 32F2 2C 01                 DC W:300                       8
1135 32F4 2C 01                 DC W:300                       9
1136 32F6
1137 32F6 C8 00        widths640 DC W:200                      1
1138 32F8 E4 00                 DC W:228                       2
1139 32FA 2C 01                 DC W:300                       3
1140 32FC 60 01                 DC W:352                       4
1141 32FE 90 01                 DC W:400                       5
1142 3300 C4 01                 DC W:452                       6
1143 3302 F4 01                 DC W:500                       7
1144 3304 28 02                 DC W:552                       8
1145 3306 58 02                 DC W:600                       9
1146 3308
1147 3308              ;
1148 3308              ; --- New window parameter list offsets ----------------------------
1149 3308              ;
1150 3308              p_length equ   0                        Number of bytes in parameter list.
1151 3308              p_wframe equ   p_length+2               Type of window, frame flags.
1152 3308              p_wtitle equ   p_wframe+2               Pointer to window's title.
1153 3308              p_wrefCon equ   p_wtitle+4              Reserved for application.
1154 3308              p_wfull  equ   p_wrefCon+4              Size of window, used with ZoomWindow.
1155 3308              p_wcolor equ   p_wfull+8                Pointer to window's color table.
1156 3308              p_y_origin equ   p_wcolor+4             Content's vertical offset.
1157 3308              p_x_origin equ   p_y_origin+2           Content's horizontal offset.
1158 3308              p_data_h equ   p_x_origin+2             Height of total data area.
1159 3308              p_data_w equ   p_data_h+2               Width of total data area.
1160 3308              p_wmaxheight equ   p_data_w+2
1161 3308              p_wmaxwidth equ   p_wmaxheight+2
1162 3308              p_vscroll equ   p_wmaxwidth+2           Amount to scroll vertically (arrows).
1163 3308              p_hscroll equ   p_vscroll+2             Amount to scroll horizonally (arrows).
1164 3308              p_vpage  equ   p_hscroll+2              Amount to page vertically (page region).
1165 3308              p_hpage  equ   p_vpage+2                Amount to page horizontally (page rgn).
1166 3308              p_wInfoText equ   p_hpage+2
1167 3308              p_wInfoH equ   p_wInfoText+4            Height of infomation bar.
1168 3308              p_wdefProc equ   p_wInfoH+2             NOT USED.
1169 3308              p_wInfoDraw equ   p_wdefProc+4          Address of routine to draw Info Bar.
1170 3308              p_updateDraw equ   p_wInfoDraw+4        Address of routine to draw content region.
1171 3308              p_position equ   p_updateDraw+4
1172 3308              p_behind equ   p_position+8
1173 3308              p_windrec equ   p_behind+4
1174 3308              p_size   equ   p_windrec+4
1175 3308
1176 3308 26 33        H3308    DC W:H3326
1177 330A FE 33                 DC W:H33FE
1178 330C D6 34                 DC W:H34D6
1179 330E 62 36                 DC W:H3662
1180 3310 46 37                 DC W:H3746
1181 3312 12 00        H3312    DC W:18
1182 3314 12 00                 DC W:18
1183 3316 12 00                 DC W:18
1184 3318 13 00                 DC W:19
1185 331A 14 00                 DC W:20
1186 331C 0C 00        H331C    DC W:12
1187 331E 0C 00                 DC W:12
1188 3320 0C 00                 DC W:12
1189 3322 0C 00                 DC W:12
1190 3324 0E 00                 DC W:14
1191 3326
1192 3326 FF FF        H3326    DC B:$FF,$FF
1193 3328 FF 00 00 00           DC B:$FF,0,0,0,0,0,0,$FF
1194 3330 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$F0,0,0,0
1195 3338 00 00 00 0F           DC B:0,0,0,$0F,$FF,$FF,$FF,$FF
1196 3340 00 00 00 00           DC B:0,0,0,0,$FF,0,0,0
1197 3348 FF FF FF F0           DC B:$FF,$FF,$FF,$F0,0,0,$0F,$F0
1198 3350 FF 0F F0 00           DC B:$FF,$0F,$F0,0,$0F,$FF,$FF,0
1199 3358 00 FF 0F F0           DC B:0,$FF,$0F,$F0,$FF,$0F,$F0,0
1200 3360 00 FF F0 00           DC B:0,$FF,$F0,0,0,$FF,$0F,$F0
1201 3368 FF 0F F0 00           DC B:$FF,$0F,$F0,0,0,$0F,0,0
1202 3370 00 FF 0F F0           DC B:0,$FF,$0F,$F0,$FF,$0F,$F0,0
1203 3378 00 00 00 00           DC B:0,0,0,0,0,$FF,$0F,$F0
1204 3380 FF 0F F0 00           DC B:$FF,$0F,$F0,0,0,0,0,0
1205 3388 00 FF FF FF           DC B:0,$FF,$FF,$FF,$FF,$FF,$F0,$0F
1206 3390 F0 00 00 00           DC B:$F0,0,0,0,0,$FF,$FF,$FF
1207 3398 FF FF 0F FF           DC B:$FF,$FF,$0F,$FF,$F0,0,0,0
1208 33A0 00 FF FF FF           DC B:0,$FF,$FF,$FF,$FF,$FF,$FF,$FF
1209 33A8 00 00 00 00           DC B:0,0,0,0,0,$FF,$FF,$FF
1210 33B0 FF FF FF F0           DC B:$FF,$FF,$FF,$F0,0,0,$F0,0
1211 33B8 00 FF FF FF           DC B:0,$FF,$FF,$FF,$FF,$FF,$FF,0
1212 33C0 00 0F FF 00           DC B:0,$0F,$FF,0,0,$FF,$FF,$FF
1213 33C8 FF FF F0 00           DC B:$FF,$FF,$F0,0,0,$FF,$FF,$F0
1214 33D0 00 0F FF FF           DC B:0,$0F,$FF,$FF,$FF,$FF,0,0
1215 33D8 0F FF FF FF           DC B:$0F,$FF,$FF,$FF,0,0,0,0
1216 33E0 00 00 00 00           DC B:0,0,0,0,$FF,$FF,$FF,$FF
1217 33E8 F0 00 00 00           DC B:$F0,0,0,0,0,0,0,$0F
1218 33F0 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,0,0,0
1219 33F8 00 00 00 FF           DC B:0,0,0,$FF,$FF,$FF
1220 33FE
1221 33FE 00 00        H33FE    DC B:0,0
1222 3400 00 00 00 00           DC B:0,0,0,0,0,0,0,0
1223 3408 00 00 0F FF           DC B:0,0,$0F,$FF,$FF,$F0,0,0
1224 3410 00 00 00 00           DC B:0,0,0,0,0,0,$0F,$FF
1225 3418 FF F0 00 00           DC B:$FF,$F0,0,0,0,0,0,0
1226 3420 00 00 0F FF           DC B:0,0,$0F,$FF,$0F,$F0,0,0
1227 3428 FF FF FF F0           DC B:$FF,$FF,$FF,$F0,0,0,$0F,$FF
1228 3430 0F F0 00 0F           DC B:$0F,$F0,0,$0F,$FF,$FF,$FF,$FF
1229 3438 00 00 0F FF           DC B:0,0,$0F,$FF,$FF,$F0,0,$FF
1230 3440 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$F0,0,$0F,$FF
1231 3448 FF F0 00 FF           DC B:$FF,$F0,0,$FF,0,$F0,$F0,0
1232 3450 F0 00 0F FF           DC B:$F0,0,$0F,$FF,$FF,$F0,0,$FF
1233 3458 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$F0,0,$0F,$FF
1234 3460 FF F0 00 FF           DC B:$FF,$F0,0,$FF,$0F,$0F,0,$F0
1235 3468 F0 00 0F FF           DC B:$F0,0,$0F,$FF,$FF,$F0,0,$FF
1236 3470 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$F0,0,$0F,$FF
1237 3478 FF F0 00 FF           DC B:$FF,$F0,0,$FF,0,$F0,$0F,$0F
1238 3480 F0 00 0F FF           DC B:$F0,0,$0F,$FF,0,0,0,$FF
1239 3488 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$F0,0,$0F,$FF
1240 3490 FF 00 00 FF           DC B:$FF,0,0,$FF,$FF,$FF,$FF,$FF
1241 3498 00 00 0F FF           DC B:0,0,$0F,$FF,$FF,0,$0F,$FF
1242 34A0 FF FF FF F0           DC B:$FF,$FF,$FF,$F0,0,0,$0F,$F0
1243 34A8 00 0F FF FF           DC B:0,$0F,$FF,$FF,$FF,$FF,$F0,0
1244 34B0 00 00 0F FF           DC B:0,0,$0F,$FF,$FF,0,0,0
1245 34B8 00 00 00 00           DC B:0,0,0,0,0,0,$0F,$FF
1246 34C0 FF 00 00 00           DC B:$FF,0,0,0,0,0,0,0
1247 34C8 00 00 00 00           DC B:0,0,0,0,0,0,0,0
1248 34D0 00 00 00 00           DC B:0,0,0,0,0,0
1249 34D6
1250 34D6 FF FF        H34D6    DC B:$FF,$FF
1251 34D8 FF FF FF 00           DC B:$FF,$FF,$FF,0,0,$FF,$FF,$FF
1252 34E0 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$F0,$0F
1253 34E8 F0 0F FF FF           DC B:$F0,$0F,$FF,$FF,$FF,$FF,$FF,$FF
1254 34F0 FF FF 00 FF           DC B:$FF,$FF,0,$FF,$FF,0,$FF,$FF
1255 34F8 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,0,$FF
1256 3500 FF 00 FF FF           DC B:$FF,0,$FF,$FF,$FF,$FF,$FF,$FF
1257 3508 FF F0 0F F0           DC B:$FF,$F0,$0F,$F0,$0F,$F0,$0F,$FF
1258 3510 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,0,$FF,0
1259 3518 00 FF 00 FF           DC B:0,$FF,0,$FF,$FF,$FF,$FF,$FF
1260 3520 FF 00 FF 00           DC B:$FF,0,$FF,0,0,$FF,0,$FF
1261 3528 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$F0,$0F,$FF,0
1262 3530 00 FF F0 0F           DC B:0,$FF,$F0,$0F,$FF,$FF,$FF,$FF
1263 3538 F0 0F FF 00           DC B:$F0,$0F,$FF,0,0,$FF,$F0,$0F
1264 3540 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,0,$FF,$FF,0
1265 3548 00 FF FF 00           DC B:0,$FF,$FF,$0,$FF,$FF,$FF,$F0
1266 3550 0F FF FF F0           DC B:$0F,$FF,$FF,$F0,$0F,$FF,$FF,$F0
1267 3558 0F FF FF F0           DC B:$0F,$FF,$FF,$F0,$0F,$FF,$FF,$F0
1268 3560 0F FF FF F0           DC B:$0F,$FF,$FF,$F0,$0F,$FF,$FF,0
1269 3568 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
1270 3570 00 FF F0 0F           DC B:0,$FF,$F0,$0F,$FF,$FF,$FF,$F0
1271 3578 0F FF FF FF           DC B:$0F,$FF,$FF,$FF,$F0,$0F,$F0,$0F
1272 3580 FF FF FF 00           DC B:$FF,$FF,$FF,0,0,$FF,$FF,$FF
1273 3588 F0 0F 00 FF           DC B:$F0,$0F,0,$FF,$FF,$FF,$FF,$F0
1274 3590 0F FF FF FF           DC B:$0F,$FF,$FF,$FF,$FF,0,0,$FF
1275 3598 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
1276 35A0 FF 00 F0 00           DC B:$FF,0,$F0,0,0,0,0,0
1277 35A8 00 00 00 00           DC B:0,0,0,0,0,$0F
1278 35AE FF FF        H35AE    DC B:$FF,$FF
1279 35B0 FF FC 00 00           DC B:$FF,$FC,0,0,$3F,$FF,$FF,$FF
1280 35B8 FF FF FF C0           DC B:$FF,$FF,$FF,$C0,0,0,3,$FF
1281 35C0 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,0,$3F,$FC
1282 35C8 00 FF FF FF           DC B:0,$FF,$FF,$FF,$FF,$FF,$FC,0
1283 35D0 FF FF 00 3F           DC B:$FF,$FF,0,$3F,$FF,$FF,$FF,$FF
1284 35D8 F0 03 F0 0F           DC B:$F0,3,$F0,$0F,$C0,$0F,$FF,$FF
1285 35E0 FF FF C0 0F           DC B:$FF,$FF,$C0,$0F,$C0,3,$F0,3
1286 35E8 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,0,$3F,$C0,3
1287 35F0 FC 00 FF FF           DC B:$FC,0,$FF,$FF,$FF,$FC,0,$FF
1288 35F8 C0 03 FF 00           DC B:$C0,3,$FF,0,$3F,$FF,$FF,$F0
1289 3600 03 FF C0 03           DC B:3,$FF,$C0,3,$FF,$C0,$0F,$FF
1290 3608 FF C0 0F FF           DC B:$FF,$C0,$0F,$FF,$F0,$0F,$FF,$F0
1291 3610 03 FF FF 00           DC B:3,$FF,$FF,0,$3F,$FF,$F0,$0F
1292 3618 FF FC 00 FF           DC B:$FF,$FC,0,$FF,$FC,0,$FF,$FF
1293 3620 FC 3F FF FF           DC B:$FC,$3F,$FF,$FF,0,$3F,$F0,3
1294 3628 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$C0,$0F
1295 3630 C0 0F FF FF           DC B:$C0,$0F,$FF,$FF,$F0,$0F,$FF,$FF
1296 3638 F0 03 00 3F           DC B:$F0,3,0,$3F,$FF,$FF,$F0,$0F
1297 3640 FF FF FC 00           DC B:$FF,$FF,$FC,0,0,$FF,$FF,$FF
1298 3648 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,0,0,0
1299 3650 00 00 00 00           DC B:0,0,0,0,0,0,0,0
1300 3658 C0 00 00 00           DC B:$C0,0,0,0,0,0,0,0
1301 3660 00 03                 DC B:0,3
1302 3662
1303 3662 00 00 00 00  H3662    DC B:0,0,0,0,0,0
1304 3668 00 00 00 00           DC B:0,0,0,0,0,0,$0F,$F0
1305 3670 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
1306 3678 0F F0 0F F0           DC B:$0F,$F0,$0F,$F0,$FF,$FF,$FF,$FF
1307 3680 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$0F,$F0,$0F,$F0
1308 3688 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
1309 3690 0F F0 0F F0           DC B:$0F,$F0,$0F,$F0,$FF,$FF,$FF,$FF
1310 3698 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$0F,$F0,$0F,$F0
1311 36A0 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
1312 36A8 0F F0 0F F0           DC B:$0F,$F0,$0F,$F0,$FF,$FF,$FF,$FF
1313 36B0 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$0F,$F0,$0F,$F0
1314 36B8 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
1315 36C0 0F F0 0F F0           DC B:$0F,$F0,$0F,$F0,$FF,$FF,$FF,$FF
1316 36C8 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$0F,$F0,$0F,$F0
1317 36D0 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
1318 36D8 0F F0 0F F0           DC B:$0F,$F0,$0F,$F0,0,0,0,0
1319 36E0 00 00 00 00           DC B:0,0,0,0,$0F,$F0,$0F,$FF
1320 36E8 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
1321 36F0 FF F0 0F FF           DC B:$FF,$F0,$0F,$FF,$FF,0,0,0
1322 36F8 00 00 00 FF           DC B:0,0,0,$FF,$FF,$F0,$0F,$FF
1323 3700 FF 00 FF 00           DC B:$FF,0,$FF,0,0,0,0,$FF
1324 3708 FF F0 0F FF           DC B:$FF,$F0,$0F,$FF,$FF,0,$FF,0
1325 3710 00 00 00 FF           DC B:0,0,0,$FF,$FF,$F0,$0F,$FF
1326 3718 FF 00 FF 00           DC B:$FF,0,$FF,0,0,0,0,$FF
1327 3720 FF F0 0F FF           DC B:$FF,$F0,$0F,$FF,$FF,0,$FF,0
1328 3728 00 00 00 FF           DC B:0,0,0,$FF,$FF,$F0,$F0,$FF
1329 3730 FF 00 00 00           DC B:$FF,0,0,0,0,0,0,$FF
1330 3738 FF F0 FF 00           DC B:$FF,$F0,$FF,0,0,0,0,0
1331 3740 00 00 00 00           DC B:0,0,0,0,0,0
1332 3746
1333 3746 FF FF        H3746    DC B:$FF,$FF
1334 3748 FF FF F0 00           DC B:$FF,$FF,$F0,0,0,0,0,0
1335 3750 0F FF FF FF           DC B:$0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF
1336 3758 0F FF FF FF           DC B:$0F,$FF,$FF,$FF,$FF,$FF,$F0,$FF
1337 3760 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$F0,$FF,$FF
1338 3768 FF FF FF F0           DC B:$FF,$FF,$FF,$F0,0,0,$FF,$FF
1339 3770 FF FF FF 0F           DC B:$FF,$FF,$FF,$0F,$FF,$FF,$FF,$FF
1340 3778 FF FF 00 0F           DC B:$FF,$FF,0,$0F,$FF,$FF,$FF,$FF
1341 3780 FF 0F FF FF           DC B:$FF,$0F,$FF,$FF,$FF,$FF,$FF,$FF
1342 3788 F0 FF FF FF           DC B:$F0,$FF,$FF,$FF,0,0,0,0
1343 3790 00 00 0F F0           DC B:0,0,$0F,$F0,0,0,0,0
1344 3798 00 00 0F 0F           DC B:0,0,$0F,$0F,$FF,$FF,$FF,$0F
1345 37A0 0F F0 F0 FF           DC B:$0F,$F0,$F0,$FF,$FF,$FF,$F0,$F0
1346 37A8 0F 0F FF FF           DC B:$0F,$0F,$FF,$FF,$FF,$0F,$0F,$F0
1347 37B0 F0 FF FF FF           DC B:$F0,$FF,$FF,$FF,$F0,$F0,$0F,$0F
1348 37B8 FF FF FF 0F           DC B:$FF,$FF,$FF,$0F,$0F,$F0,$F0,$FF
1349 37C0 FF FF F0 F0           DC B:$FF,$FF,$F0,$F0,$0F,0,0,0
1350 37C8 00 0F 0F F0           DC B:0,$0F,$0F,$F0,$F0,0,0,0
1351 37D0 00 F0 0F FF           DC B:0,$F0,$0F,$FF,$FF,$FF,$FF,$FF
1352 37D8 0F F0 FF FF           DC B:$0F,$F0,$FF,$FF,$FF,$FF,$FF,$F0
1353 37E0 0F F0 00 00           DC B:$0F,$F0,0,0,$0F,$FF,$0F,$F0
1354 37E8 FF 00 00 00           DC B:$FF,0,0,0,$FF,$F0,$0F,$F0
1355 37F0 F0 00 0F FF           DC B:$F0,0,$0F,$FF,$0F,$F0,$FF,$0F
1356 37F8 00 00 FF F0           DC B:0,0,$FF,$F0,$0F,$F0,$F0,0
1357 3800 0F FF 0F F0           DC B:$0F,$FF,$0F,$F0,$FF,$0F,0,0
1358 3808 FF F0 F0 00           DC B:$FF,$F0,$F0,0,0,0,0,0
1359 3810 0F FF 00 00           DC B:$0F,$FF,0,0,0,0,0,0
1360 3818 FF FF FF 0F           DC B:$FF,$FF,$FF,$0F,$FF,$FF,$FF,$FF
1361 3820 FF FF F0 FF           DC B:$FF,$FF,$F0,$FF,$FF,$FF,$FF,$FF
1362 3828 F0 00 FF FF           DC B:$F0,0,$FF,$FF,$FF,$FF,$FF,$FF
1363 3830 F0 FF FF FF           DC B:$F0,$FF,$FF,$FF,$FF,$FF,0,0
1364 3838 0F FF FF FF           DC B:$0F,$FF,$FF,$FF,$FF,$FF,$0F,$FF
1365 3840 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$0F,$FF,$FF
1366 3848 FF FF FF F0           DC B:$FF,$FF,$FF,$F0,$FF,$FF,$FF,$FF
1367 3850 FF FF FF F0           DC B:$FF,$FF,$FF,$F0,0,0,0,0
1368 3858 00 0F FF FF           DC B:0,$0F,$FF,$FF,$FF,$FF
1369 385E
1370 385E                       ENDP 
1371 385E
1372 385E
1373 385E              ****************************************************************
1374 385E              *
1375 385E              * ErrorWindow
1376 385E              *
1377 385E              * Description       This call displays an alert window containing
1378 385E              *                   standard system error messages.
1379 385E              *
1380 385E              * Inputs:
1381 385E              *                   Previous contents
1382 385E              *                   Result space        WORD
1383 385E              *                   Sub. Strng. Type    WORD  0 = C string, 1 = Pascal
1384 385E              *                   Pointer to sub mess LONG
1385 385E              *                   Error number        WORD
1386 385E              *
1387 385E              * Outputs:
1388 385E              *                   Previous contents
1389 385E              *                   Result              WORD  Button number selected
1390 385E              *
1391 385E              ****************************************************************
1392 385E                       longa on                       ; mode
1393 385E                       longi on
1394 385E
1395 385E              ErrorWindow    PROC EXPORT 
1396 385E
1397 385E                       DefineStack 
1398 385E              OrigD    word 
1399 385E
1400 385E              HexString long 
1401 385E              Terminator word 
1402 385E              Temp     long 
1403 385E              Ret1     block 3 
1404 385E              Ret2     block 3 
1405 385E              ErrorNum word 
1406 385E              substrgs long 
1407 385E              strgType word 
1408 385E              result   word 
1409 385E
1410 385E 22 64 00 E1           jsl   IncBusyFlg
1411 3862
1412 3862 A9 00 00              lda   #0                       ;Cstring terminator
1413 3865 48                    pha   
1414 3866 48                    pha                            ;room hex string
1415 3867 48                    pha   
1416 3868
1417 3868 48                    pha                            ;temp
1418 3869 48                    pha   
1419 386A
1420 386A 0B                    phd   
1421 386B 3B                    tsc   
1422 386C 5B                    tcd   
1423 386D
1424 386D              ;
1425 386D              ; Set up for the alert window call
1426 386D              ;
1427 386D 48                    pha                            ;space for result
1428 386E              *** Force the cool button position bit on
1429 386E A5 19                 lda   <strgType
1430 3870 48                    pha   
1431 3871              ;
1432 3871              ; Alert Window wants a pointer to a table of pointers for the substitution strings.
1433 3871              ;  Since we only allow one substitution, item 0, we simply need a pointer to a pointer.
1434 3871              ;  We are passed a pointer, so we pass a pointer to the pointer we are passed.
1435 3871              ;
1436 3871 F4 00 00              pea   $0000                    ;msw of pointer to pointer
1437 3874 7B                    tdc   
1438 3875 18                    clc   
1439 3876 69 15 00              adc   #substrgs                ;lsw of pointer to pointer
1440 3879 48                    pha   
1441 387A              ;
1442 387A              ; Make LoadResource call to get error message
1443 387A              ;
1444 387A 48                    pha                            ;space for result
1445 387B 48                    pha   
1446 387C F4 20 80              pea   $8020                    ;Resource ID type: rErrorString
1447 387F
1448 387F F4 FF 07              pea   $07FF                    ;msw of error is 0
1449 3882 A5 13                 lda   <ErrorNum
1450 3884 48                    pha   
1451 3885 A2 1E 0E 22           _LoadResource 
1452 388C
1453 388C 90 51                 bcc   NoRezLoadError
1454 388E              ;
1455 388E              ; Error in load resource.  Clean stack and display 'unknown error' message
1456 388E              ;
1457 388E AA                    tax                            ;save error number
1458 388F 68                    pla                            ;clean stack
1459 3890 68                    pla   
1460 3891 68                    pla   
1461 3892 68                    pla   
1462 3893 68                    pla   
1463 3894 68                    pla   
1464 3895              ;
1465 3895              ; Start over: first create hex error number and a pointer to it
1466 3895              ;
1467 3895
1468 3895 48                    pha                            ;space for result
1469 3896 48                    pha   
1470 3897 A5 13                 lda   <ErrorNum
1471 3899 48                    pha   
1472 389A A2 0B 2A 22           _HexIt                         ;leaves 4 byte hex string on stack
1473 38A1
1474 38A1 68                    pla   
1475 38A2 85 03                 sta   <HexString
1476 38A4 68                    pla   
1477 38A5 85 05                 sta   <HexString+2
1478 38A7              ;
1479 38A7              ;create pointer to string and put it in substrgs
1480 38A7              ;
1481 38A7 A9 00 00              lda   #0
1482 38AA 85 17                 sta   <substrgs+2              ;msw is 0 since its on the stack
1483 38AC 7B                    tdc   
1484 38AD 18                    clc   
1485 38AE 69 03 00              adc   #HexString
1486 38B1 85 15                 sta   <substrgs
1487 38B3              ;
1488 38B3              ; Set up for the alert window call
1489 38B3              ;
1490 38B3 48                    pha                            ;space for result
1491 38B4 A9 00 00              lda   #0
1492 38B7 48                    pha   
1493 38B8
1494 38B8              ;
1495 38B8              ; Create a pointer to the error number and pass it to alert window
1496 38B8              ;
1497 38B8 F4 00 00              pea   $0000                    ;msw of pointer error number
1498 38BB 7B                    tdc   
1499 38BC 18                    clc   
1500 38BD 69 15 00              adc   #substrgs                ;lsw of pointer to pointer
1501 38C0 48                    pha   
1502 38C1
1503 38C1              ;
1504 38C1              ; Make LoadResource call to get unknown error message
1505 38C1              ;
1506 38C1 48                    pha                            ;space for result
1507 38C2 48                    pha   
1508 38C3 F4 20 80              pea   $8020                    ;Resource ID type: rErrorString
1509 38C6
1510 38C6 F4 FF 07              pea   $07FF                    ;msw of error is 0
1511 38C9 A9 72 00              lda   #$0072
1512 38CC 48                    pha   
1513 38CD A2 1E 0E 22           _LoadResource 
1514 38D4
1515 38D4 90 09                 bcc   NoRezLoadError
1516 38D6
1517 38D6              ;
1518 38D6              ; Error in loading unknown error resource.  Clean stack and exit
1519 38D6              ;
1520 38D6              LoadError  
1521 38D6 AA                    tax                            ;save error number
1522 38D7
1523 38D7 68                    pla                            ;clean stack: resource handle
1524 38D8 68                    pla   
1525 38D9
1526 38D9 68                    pla                            ;remove sub string pointer
1527 38DA 68                    pla   
1528 38DB
1529 38DB 68                    pla                            ;string type
1530 38DC 68                    pla                            ;result space
1531 38DD
1532 38DD 80 43                 bra   ErrorExit
1533 38DF
1534 38DF              NoRezLoadError  
1535 38DF 68                    pla   
1536 38E0 85 09                 sta   temp                     ;handle to resource
1537 38E2 68                    pla   
1538 38E3 85 0B                 sta   temp+2
1539 38E5
1540 38E5 A0 04 00              ldy   #4
1541 38E8 B7 09                 lda   [<temp],y
1542 38EA 09 00 80              ora   #$8000                   ;lock it
1543 38ED 97 09                 sta   [<temp],y
1544 38EF
1545 38EF A0 02 00              ldy   #2
1546 38F2 B7 09                 lda   [<temp],y
1547 38F4 48                    pha                            ;pass pointer to error message
1548 38F5 A7 09                 lda   [<temp]
1549 38F7 48                    pha   
1550 38F8
1551 38F8 A2 0E 59 22           _AlertWindow 
1552 38FF AA                    tax   
1553 3900 68                    pla   
1554 3901 85 1B                 sta   <result
1555 3903
1556 3903 A0 04 00              ldy   #4
1557 3906 B7 09                 lda   [<temp],y
1558 3908 29 FF 7F              and   #$7FFF
1559 390B 97 09                 sta   [<temp],y                ;unlock handle
1560 390D
1561 390D DA                    phx                            ;save error message
1562 390E              ;
1563 390E              ; setup for release resource call
1564 390E              ;
1565 390E F4 03 00              pea   $0003                    ;most purgeable
1566 3911 F4 20 80              pea   $8020                    ;resource type
1567 3914 F4 FF 07              pea   $07FF
1568 3917 A5 13                 lda   <ErrorNum
1569 3919 48                    pha   
1570 391A A2 1E 17 22           _ReleaseResource 
1571 3921
1572 3921 FA                    plx                            ;restore error message
1573 3922
1574 3922 A5 11        errorExit lda   <Ret1+4                 ;Move return address down stack.
1575 3924 85 19                 sta   <result-2
1576 3926 A5 0F                 lda   <Ret1+2
1577 3928 85 17                 sta   <result-4
1578 392A A5 0D                 lda   <Ret1
1579 392C 85 15                 sta   <result-6
1580 392E
1581 392E 2B                    pld   
1582 392F 68                    pla                            ;temp work area
1583 3930 68                    pla   
1584 3931
1585 3931 68                    pla                            ;hex string
1586 3932 68                    pla                            ;hex string
1587 3933 68                    pla                            ;0 terminator
1588 3934
1589 3934 68                    pla                            ;remove input parameters froms stack
1590 3935 68                    pla   
1591 3936 68                    pla   
1592 3937 68                    pla   
1593 3938 DA                    phx                            ;error result from AlertWindow
1594 3939
1595 3939 22 68 00 E1           jsl   DecBusyFlg
1596 393D 68                    pla                            ;get error result
1597 393E C9 00 00              cmp   #0
1598 3941
1599 3941 6B                    rtl   
1600 3942
1601 3942
1602 3942                       ENDP 
1603 3942
1604 3942
1605 3942              ;===================================================
1606 3942              ;                   Compile string.
1607 3942              ;===================================================
1608 3942              ;
1609 3942              ;   IN:    PUSH:LONG - space for result, handle of compiled string.
1610 3942              ;          PUSH:WORD - 0 if substitution strings are C type (null or return).
1611 3942              ;                      1 if substitution strings are Pascal type (length byte).
1612 3942              ;          PUSH:LONG - pointer to substitution strings.
1613 3942              ;          PUSH:LONG - pointer to source string.
1614 3942              ;          PUSH:WORD - size of source string.
1615 3942              ;
1616 3942              ;  OUT:    Carry clear, handle of compiled string on stack. Handle size is size of text.
1617 3942              ;          Carry set if error, a = error code (compileTooLarge = compiled string too large).
1618 3942              ;
1619 3942              ; Any '#' followed by an ASCII digit character with be substituted with a standard string
1620 3942              ; defined in AlertWindow documentation.  Any '*' character followed by an ASCII digit 
1621 3942              ; character with be substituted with its corresponding string in the given substitution
1622 3942              ; array.  If no * substitutions are in the string the pointer to the substitution array
1623 3942              ; can be any value including nil.
1624 3942              ;
1625 3942              ; Characters # and * can be made part of the compiled string by having them twice in the
1626 3942              ; source string.
1627 3942              ;
1628 3942              CompileString PROC EXPORT 
1629 3942
1630 3942              srcIndex equ   1
1631 3942              desIndex equ   srcIndex+2
1632 3942              desSize  equ   desIndex+2
1633 3942              ptr      equ   desSize+2
1634 3942              ptr2     equ   ptr+4
1635 3942              saveDpage equ   ptr2+4
1636 3942              saveDbank equ   saveDpage+2
1637 3942              returnAddr equ   saveDbank+1
1638 3942              inputs   equ   returnAddr+6
1639 3942
1640 3942              srcSize  equ   inputs
1641 3942              srcStrg  equ   srcSize+2
1642 3942              substrgs equ   srcStrg+4
1643 3942              strgType equ   substrgs+4
1644 3942              result   equ   strgType+2
1645 3942
1646 3942
1647 3942 8B                    phb                            Save caller's data bank pointer.
1648 3943 0B                    phd                            Save caller's direct page pointer.
1649 3944
1650 3944 3B                    tsc                            Swtich to direct page in stack.
1651 3945 38                    sec   
1652 3946 E9 0E 00              sbc   #saveDpage-1
1653 3949 1B                    tcs   
1654 394A 5B                    tcd   
1655 394B
1656 394B 4B                    phk                            Switch data bank to program bank.
1657 394C AB                    plb   
1658 394D              ;
1659 394D              ;
1660 394D              ; --- Allocate memory for text string ------------------------
1661 394D              ;
1662 394D A2 00 00              ldx   #0                       Common need.
1663 3950
1664 3950 48                    pha                            Space for result.
1665 3951 48                    pha   
1666 3952 DA                    phx                            Pass number of bytes to allocate.
1667 3953 A5 18                 lda   <srcSize
1668 3955 85 05                 sta   <desSize
1669 3957 48                    pha   
1670 3958 F4 01 10              pea   $1001                    Pass ID to use.
1671 395B DA                    phx                            Pass attributes, anywhere, anyhow.
1672 395C 48                    pha                            Pass address (not used).
1673 395D 48                    pha   
1674 395E A2 02 09 22           _NewHandle 
1675 3965 68                    pla   
1676 3966 85 24                 sta   <result
1677 3968 68                    pla   
1678 3969 85 26                 sta   <result+2
1679 396B              ;
1680 396B 20 93 3A              jsr   derefHand                ptr = (handle)
1681 396E              ;
1682 396E 64 03                 stz   <desIndex                Start storing into first byte in destination.
1683 3970 64 01                 stz   <srcIndex
1684 3972              ;
1685 3972              ;
1686 3972              ; --- Compile text string.
1687 3972              ;
1688 3972 20 EF 39     @lop1    jsr   fetchSrcChar             Fetch next source character.
1689 3975 B0 46                 bcs   @done                    All done?
1690 3977              ;
1691 3977              ;
1692 3977              ; ------ Substitute standard string?
1693 3977              ;
1694 3977 C9 23 00              cmp   #'#'                     Substitute standard string character?
1695 397A D0 18                 bne   @next1
1696 397C              ;
1697 397C 20 FE 39              jsr   fetchDigit               Fetch which standard string to use.
1698 397F B0 24                 bcs   @store1                  Next character a digit?
1699 3981              ;
1700 3981 0A                    asl   a                        Substitute standard string.
1701 3982 AA                    tax   
1702 3983 BD 9F 3A              lda   |standButts,x
1703 3986 85 0B                 sta   <ptr2
1704 3988 A9 FD 00              lda   #standButts>>16
1705 398B 85 0D                 sta   <ptr2+2
1706 398D 20 7E 3A              jsr   Ctype                    Move standard string into text.
1707 3990 90 E0                 bcc   @lop1                    Get next character if buffer not full.
1708 3992 80 16                 bra   @errorOut                Buffer is full.
1709 3994              ;
1710 3994              ;
1711 3994              ; ------ Speical subsitution character?
1712 3994              ;
1713 3994 C9 2A 00     @next1   cmp   #'*'                     Speical subsitution character?
1714 3997 D0 0C                 bne   @store1
1715 3999              ;
1716 3999 20 FE 39              jsr   fetchDigit               Fetch which subsitute string to use.
1717 399C B0 07                 bcs   @store1                  Next character a digit?
1718 399E              ;
1719 399E 20 4F 3A              jsr   storeSub                 Store substitution string in text.
1720 39A1 90 CF                 bcc   @lop1                    Get next character if buffer not full.
1721 39A3 80 05                 bra   @errorOut                Buffer is full.
1722 39A5              ;
1723 39A5              ;
1724 39A5 20 18 3A     @store1  jsr   storeChar                Store character in destination buffer.
1725 39A8 90 C8                 bcc   @lop1
1726 39AA              ;
1727 39AA              ;
1728 39AA              ; --- Error exit.
1729 39AA              ;
1730 39AA 48           @errorOut pha                           Save error code.
1731 39AB              ;
1732 39AB D4 26                 pei   <result+2                Pass handle of destination buffer.
1733 39AD D4 24                 pei   <result
1734 39AF A2 02 10 22           _DisposeHandle                 Free destination buffer.
1735 39B6 64 24                 stz   <result                  Return NIL handle.
1736 39B8 64 26                 stz   <result+2
1737 39BA
1738 39BA 7A                    ply                            Restore error code.
1739 39BB 80 13                 bra   @exit
1740 39BD              ;
1741 39BD              ;
1742 39BD              ; --- Clean up stack and exit.
1743 39BD              ;
1744 39BD F4 00 00     @done    pea   0                        Set compiled string handle to size of text.
1745 39C0 D4 03                 pei   <desIndex
1746 39C2 D4 26                 pei   <result+2
1747 39C4 D4 24                 pei   <result
1748 39C6 A2 02 19 22           _SetHandleSize 
1749 39CD
1750 39CD A0 00 00              ldy   #0                       No error.
1751 39D0
1752 39D0 A5 16        @exit    lda   <returnAddr+4
1753 39D2 85 22                 sta   <result-2
1754 39D4 A5 14                 lda   <returnAddr+2
1755 39D6 85 20                 sta   <result-4
1756 39D8 A5 12                 lda   <returnAddr
1757 39DA 85 1E                 sta   <result-6
1758 39DC
1759 39DC 3B                    tsc                            Free temp direct page.
1760 39DD 18                    clc   
1761 39DE 69 0E 00              adc   #saveDpage-1
1762 39E1 1B                    tcs   
1763 39E2
1764 39E2 2B                    pld                            Restore caller's direct page pointer.
1765 39E3 AB                    plb                            Restore caller's data bank pointer.
1766 39E4
1767 39E4 3B                    tsc                            Remove input parameter from stack.
1768 39E5 18                    clc   
1769 39E6 69 0C 00              adc   #result-inputs
1770 39E9 1B                    tcs   
1771 39EA
1772 39EA 98                    tya                            Return error code in a.
1773 39EB C9 01 00              cmp   #1                       Set error flag.
1774 39EE 6B                    rtl   
1775 39EF
1776 39EF
1777 39EF              ;------------------------------------------------------------------------------
1778 39EF              ;                   Fetch a character from source buffer.
1779 39EF              ;------------------------------------------------------------------------------
1780 39EF              ;
1781 39EF              ;    IN: <srcStrg = pointer to source buffer.
1782 39EF              ;        <srcIndex = index to next character in source buffer.
1783 39EF              ;        <srcSize = size of source buffer.
1784 39EF              ;
1785 39EF              ;   OUT: <srcIndex = incremented to next character.
1786 39EF              ;        Carry clear if a = character in low byte, high byte = zero.
1787 39EF              ;        Carry set if no more characters.
1788 39EF              ;
1789 39EF A4 01        fetchSrcChar ldy   <srcIndex
1790 39F1 C4 18                 cpy   <srcSize
1791 39F3 B0 08                 bcs   @exit                    ;No more characters?
1792 39F5
1793 39F5 B7 1A                 lda   [<srcStrg],y
1794 39F7 29 FF 00              and   #$00FF
1795 39FA E6 01                 inc   <srcIndex
1796 39FC 18                    clc                            ;Character fetched flag.
1797 39FD 60           @exit    rts   
1798 39FE
1799 39FE
1800 39FE              ;-------------------------------------------------------------
1801 39FE              ;          Fetch and convert a ASCII decimal digit.
1802 39FE              ;-------------------------------------------------------------
1803 39FE              ;
1804 39FE              ;    IN: <srcStrg = pointer to source buffer.
1805 39FE              ;        <srcIndex = index to ASCII decimal digits.
1806 39FE              ;
1807 39FE              ;  OUT:  <srcIndex = next character.
1808 39FE              ;        Carry clear, a = digit.
1809 39FE              ;        Carry set, a = character that wasn't a decimal digit.
1810 39FE              ;
1811 39FE 20 EF 39     fetchDigit jsr   fetchSrcChar           ;Fetch the next character.
1812 3A01 90 05                 bcc   @ok1                     ;No more characters?
1813 3A03 A9 00 00              lda   #0                       ;Return null character.
1814 3A06 38           @notDigitExit sec   
1815 3A07 60                    rts   
1816 3A08
1817 3A08 C9 30 00     @ok1     cmp   #'0'                     ;Is the next character a digit?
1818 3A0B 90 F9                 bcc   @notDigitExit
1819 3A0D C9 3A 00              cmp   #'9'+1
1820 3A10 B0 F4                 bcs   @notDigitExit
1821 3A12              *** CARRY IS CLEAR
1822 3A12 38                    sec   
1823 3A13 E9 30 00              sbc   #'0'
1824 3A16 18                    clc                            ;a = digit.
1825 3A17              * CARRY IS CLEAR FROM ABOVE
1826 3A17 60                    rts   
1827 3A18
1828 3A18
1829 3A18              ;------------------------------------------------------------------------------
1830 3A18              ;                   Store character into destination buffer.
1831 3A18              ;------------------------------------------------------------------------------
1832 3A18              ;
1833 3A18              ;   IN: a = character to store, only the low byte used.
1834 3A18              ;       <desPtr = pointer to destination buffer.
1835 3A18              ;       <desIndex = index to where to store character in destination buffer.
1836 3A18              ;       <desSize = size of destination buffer.
1837 3A18              ;
1838 3A18              ;  OUT: Carry set if error, a = error code (1=des too large).
1839 3A18              ;       Destination buffer may have had to be resized.  If so, handle is dereferenced again.
1840 3A18              ;
1841 3A18 A4 03        storeChar ldy   <desIndex               ;Is there room in the destination buffer?
1842 3A1A C4 05                 cpy   <desSize
1843 3A1C 90 25                 bcc   @ok1
1844 3A1E              ;
1845 3A1E              ;
1846 3A1E              ; --- Grow the destination buffer.
1847 3A1E              ;
1848 3A1E 48                    pha                            Save character to store.
1849 3A1F A5 05                 lda   <desSize                 Increase destination buffer size.
1850 3A21 18                    clc   
1851 3A22 69 00 01              adc   #256
1852 3A25 90 05                 bcc   @ok2
1853 3A27 A9 04 0E              lda   #$0E04                   Error, destination too large.
1854 3A2A              ;                                       (compileTooLarge not available)
1855 3A2A FA           @errorOut plx                           Clean up stack.
1856 3A2B 60                    rts   
1857 3A2C
1858 3A2C 85 05        @ok2     sta   <desSize                 New buffer size.
1859 3A2E F4 00 00              pea   0                        Pass new size.
1860 3A31 48                    pha   
1861 3A32 D4 26                 pei   <result+2                Pass handle of destination buffer.
1862 3A34 D4 24                 pei   <result
1863 3A36 A2 02 19 22           _SetHandleSize 
1864 3A3D B0 EB                 bcs   @errorOut
1865 3A3F 20 93 3A              jsr   derefHand                Dereference destination buffer.
1866 3A42 68                    pla                            Restore character to store.
1867 3A43              ;
1868 3A43              ;
1869 3A43              ; --- Store the character.
1870 3A43              ;
1871 3A43 A4 03        @ok1     ldy   <desIndex
1872 3A45 E2 20                 sep   #$20                     Go to 8 bit.
1873 3A47                       LONGA OFF
1874 3A47 97 07                 sta   [<ptr],y                 Store character in destination buffer.
1875 3A49 C2 20                 rep   #$20                     Back to 16 bit.
1876 3A4B                       LONGA ON
1877 3A4B
1878 3A4B E6 03                 inc   <desIndex                Increment destination index.
1879 3A4D
1880 3A4D 18                    clc                            No error.
1881 3A4E 60                    rts   
1882 3A4F              ;
1883 3A4F              ;
1884 3A4F              ;------------------------------------------------------------------------------
1885 3A4F              ;                   Move string into destination text.
1886 3A4F              ;------------------------------------------------------------------------------
1887 3A4F              ;
1888 3A4F              ;   IN:    a = substitution string number.
1889 3A4F              ;          <subStrgs = pointer to array of string pointers.
1890 3A4F              ;          <ptr = pointer to destination string.
1891 3A4F              ;          <work = length counter of destination string.
1892 3A4F              ;          <strgType = 0 if C sub strings, 1 if Pascal sub strings.
1893 3A4F              ;
1894 3A4F              ;  OUT:    Carry set if buffer full.
1895 3A4F              ;
1896 3A4F 0A           storeSub asl   a                        Compute index.
1897 3A50 0A                    asl   a
1898 3A51 A8                    tay   
1899 3A52 B7 1E                 lda   [<subStrgs],y            Get pointer to subsitute string.
1900 3A54 85 0B                 sta   <ptr2
1901 3A56 C8                    iny   
1902 3A57 B7 1E                 lda   [<subStrgs],y
1903 3A59 85 0C                 sta   <ptr2+1
1904 3A5B
1905 3A5B A5 22                 lda   <strgType                C type string?
1906 3A5D F0 1F                 beq   Ctype
1907 3A5F              ;
1908 3A5F              ;
1909 3A5F              ; --- Pascal type string -------------------------------------
1910 3A5F              ;
1911 3A5F A7 0B                 lda   [<ptr2]                  Get number of bytes in string.
1912 3A61 29 FF 00              and   #$00FF
1913 3A64 F0 16                 beq   @exit1
1914 3A66 AA                    tax   
1915 3A67 A0 01 00              ldy   #1
1916 3A6A B7 0B        @lop1    lda   [<ptr2],y
1917 3A6C 29 FF 00              and   #$00FF
1918 3A6F 5A                    phy   
1919 3A70 DA                    phx   
1920 3A71 20 18 3A              jsr   storeChar
1921 3A74 FA                    plx   
1922 3A75 7A                    ply   
1923 3A76 B0 05                 bcs   @exit2
1924 3A78 C8                    iny   
1925 3A79 CA                    dex   
1926 3A7A D0 EE                 bne   @lop1
1927 3A7C 18           @exit1   clc   
1928 3A7D 60           @exit2   rts   
1929 3A7E
1930 3A7E
1931 3A7E              ;---------------------------------------------------------------
1932 3A7E              ;                   Insert C type string.
1933 3A7E              ;---------------------------------------------------------------
1934 3A7E              ;
1935 3A7E              ;   IN: <ptr2 = pointer to C string to insert.
1936 3A7E              ;
1937 3A7E A0 00 00     Ctype    ldy   #0
1938 3A81 B7 0B        @lop1    lda   [<ptr2],y
1939 3A83 29 FF 00              and   #$00FF
1940 3A86 F0 09                 beq   @exit1                   End of substitution string?
1941 3A88 C8                    iny   
1942 3A89 5A                    phy   
1943 3A8A 20 18 3A              jsr   storeChar
1944 3A8D 7A                    ply   
1945 3A8E 90 F1                 bcc   @lop1
1946 3A90 60                    rts   
1947 3A91
1948 3A91 18           @exit1   clc                            Buffer OK.
1949 3A92 60                    rts   
1950 3A93
1951 3A93
1952 3A93              ;---------------------------------------------------------------
1953 3A93              ;                   Dereference handle.
1954 3A93              ;---------------------------------------------------------------
1955 3A93              ;
1956 3A93 A0 02 00     derefHand ldy   #2
1957 3A96 B7 24                 lda   [<result],y
1958 3A98 85 09                 sta   <ptr+2
1959 3A9A A7 24                 lda   [<result]
1960 3A9C 85 07                 sta   <ptr
1961 3A9E 60                    rts   
1962 3A9F              ;
1963 3A9F              ;
1964 3A9F              ; --- Standard button strings --------------------------------
1965 3A9F              ;
1966 3A9F B3 3A        standButts DC W:OK                      0
1967 3AA1 B6 3A                 DC W:Cancel                    1
1968 3AA3 BD 3A                 DC W:Yes                       2
1969 3AA5 C1 3A                 DC W:No                        3
1970 3AA7 C4 3A                 DC W:TryAgain                  4
1971 3AA9 CE 3A                 DC W:Quit                      5
1972 3AAB D3 3A                 DC W:Continue                  6
1973 3AAD DB 3A                 DC W:Bad                       7
1974 3AAF DB 3A                 DC W:Bad                       8
1975 3AB1 DB 3A                 DC W:Bad                       9
1976 3AB3
1977 3AB3                       STRING ASIS 
1978 3AB3 4F 4B        OK       DC B:'OK',0
1979 3AB5 00 43        Cancel   DC B:'Cancel',0
1980 3AB7 61 6E        Yes      DC B:'Yes',0
1981 3AB9 63 65        No       DC B:'No',0
1982 3ABB 6C 00        TryAgain DC B:'Try Again',0
1983 3ABD 59 65        Quit     DC B:'Quit',0
1984 3ABF 73 00 4E 6F  Continue DC B:'Continue'
1985 3AC7 20           Bad      DC B:0
1986 3AC8
1987 3AC8                       ENDP 
